<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

use Polkurier\Order\ConfigStatus;

$polkurier_path = __DIR__ . '/';
require_once($polkurier_path . 'PolkurierWebServiceApi/autoload.php');

require_once($polkurier_path . 'Polkurier/Model/SqlAbstract.php');
require_once($polkurier_path . 'Polkurier/Model/Model.php');
require_once($polkurier_path . 'Polkurier/Model/PolkurierConfig.php');
require_once($polkurier_path . 'Polkurier/Model/CountryModel.php');
require_once($polkurier_path . 'Polkurier/Model/Shipment/CashonDelivery.php');
require_once($polkurier_path . 'Polkurier/Model/Shipment/OrderAdres.php');
require_once($polkurier_path . 'Polkurier/Model/Shipment/Receiver.php');
require_once($polkurier_path . 'Polkurier/Model/Shipment/Sender.php');
require_once($polkurier_path . 'Polkurier/Model/Shipment/ShipmentModel.php');
require_once($polkurier_path . 'Polkurier/Model/Shipment/ShipmenPack.php');
require_once($polkurier_path . 'Polkurier/Model/Shipment/CodShipment.php');
require_once($polkurier_path . 'Polkurier/Model/Shipment/ShipmentPickup.php');
require_once($polkurier_path . 'Polkurier/Model/Shipment/ShipmentAdditionalServices.php');
require_once($polkurier_path . 'Polkurier/Model/Shipment/NewShipment/NewShipmentModel.php');
require_once($polkurier_path . 'Polkurier/Model/Shipment/NewShipment/DeliveryAddressModel.php');
require_once($polkurier_path . 'Polkurier/Model/Shipment/NewShipment/SenderAddressModel.php');
require_once($polkurier_path . 'Polkurier/Model/Shipment/FormShipment/FormShipmentModel.php');

require_once($polkurier_path . 'Polkurier/Model/Shipment/NewShipment/Module/DeliveryAddress/DeliveryAddressModule.php');
require_once($polkurier_path . 'Polkurier/Model/Shipment/NewShipment/Module/DeliveryAddress/InpostMachines/Sensbit/SensbitPaczkomaty.php');
require_once($polkurier_path . 'Polkurier/Model/Shipment/NewShipment/Module/DeliveryAddress/InpostMachines/Sensbit/SensbitInpost.php');
require_once($polkurier_path . 'Polkurier/Model/Shipment/NewShipment/Module/DeliveryAddress/InpostMachines/PrestaModPl/PmInpostPaczkomaty.php');
require_once($polkurier_path . 'Polkurier/Model/Shipment/NewShipment/Module/DeliveryAddress/InpostMachines/Furgonetka/FurgonetkaPaczkomaty.php');
require_once($polkurier_path . 'Polkurier/Model/Shipment/NewShipment/Module/DeliveryAddress/InpostMachines/InpostShipping/InpostShipping.php');
require_once($polkurier_path . 'Polkurier/Model/Shipment/NewShipment/Module/DeliveryAddress/DeliveryPoint/Apaczka/ApaczkaDeliveryPoint.php');

require_once($polkurier_path . 'Polkurier/CodType.php');
require_once($polkurier_path . 'Polkurier/CodReturnTime.php');
require_once($polkurier_path . 'Polkurier/UpdateConfigPolkurierApi.php');

//ApiMetod
require_once($polkurier_path . 'Polkurier/ApiMetod/ApiClient.php');
require_once($polkurier_path . 'Polkurier/ApiMetod/AvailableCarriersApi.php');
require_once($polkurier_path . 'Polkurier/ApiMetod/OrderValuationApi.php');
require_once($polkurier_path . 'Polkurier/ApiMetod/PickupCourierApi.php');
require_once($polkurier_path . 'Polkurier/ApiMetod/PlaceOrderApi.php');
require_once($polkurier_path . 'Polkurier/ApiMetod/CancelOrderApi.php');
require_once($polkurier_path . 'Polkurier/ApiMetod/LabelOrderApi.php');
require_once($polkurier_path . 'Polkurier/ApiMetod/ProtocolOrderApi.php');
require_once($polkurier_path . 'Polkurier/ApiMetod/StatusOrderApi.php');
require_once($polkurier_path . 'Polkurier/ApiMetod/ApiUtils.php');
require_once($polkurier_path . 'Polkurier/ApiMetod/GetMapTokenApi.php');
require_once($polkurier_path . 'Polkurier/ApiMetod/CourierPointApi.php');


//sender
require_once($polkurier_path . 'Polkurier/Sender/SqlSender.php');
require_once($polkurier_path . 'Polkurier/Sender/SenderModel.php');
require_once($polkurier_path . 'Polkurier/Sender/SenderListModel.php');
require_once($polkurier_path . 'Polkurier/Sender/Sender.php');
//sender order
require_once($polkurier_path . 'Polkurier/SenderOrder/SqlSenderOrder.php');
require_once($polkurier_path . 'Polkurier/SenderOrder/SenderOrderModel.php');
//Receiver
require_once($polkurier_path . 'Polkurier/Receiver/SqlReceiver.php');
require_once($polkurier_path . 'Polkurier/Receiver/ReceiverModel.php');
//Parcel
require_once($polkurier_path . 'Polkurier/Parcel/ParcelSql.php');
require_once($polkurier_path . 'Polkurier/Parcel/ParcelModel.php');
require_once($polkurier_path . 'Polkurier/Parcel/ParcelListModel.php');
require_once($polkurier_path . 'Polkurier/Parcel/Parcel.php');
//bank
require_once($polkurier_path . 'Polkurier/Bank/SqlBank.php');
require_once($polkurier_path . 'Polkurier/Bank/BankModel.php');
require_once($polkurier_path . 'Polkurier/Bank/BankListModel.php');
require_once($polkurier_path . 'Polkurier/Bank/Bank.php');
//order
require_once($polkurier_path . 'Polkurier/Order/CreateNewOrder.php');
require_once($polkurier_path . 'Polkurier/Order/RefreshOrderStatusPolkurier.php');
require_once($polkurier_path . 'Polkurier/Order/UpdatePrestaOrderStatus.php');
require_once($polkurier_path . 'Polkurier/Order/OrderStatusTraking.php');
require_once($polkurier_path . 'Polkurier/Order/ConfigStatus.php');
require_once($polkurier_path . 'Polkurier/Order/OrdersSql.php');
require_once($polkurier_path . 'Polkurier/Order/OrdersModel.php');
require_once($polkurier_path . 'Polkurier/Order/OrderPolkurier.php');
require_once($polkurier_path . 'Polkurier/Order/CreateNewOrder.php');
require_once($polkurier_path . 'Polkurier/Order/OrderNewSave.php');
require_once($polkurier_path . 'Polkurier/Order/OrderValuation.php');
require_once($polkurier_path . 'Polkurier/Order/OrderDetal.php');
//Parcel order
require_once($polkurier_path . 'Polkurier/ParcelOrder/ParcelOrderSql.php');
require_once($polkurier_path . 'Polkurier/ParcelOrder/ModelParcelOrder.php');
require_once($polkurier_path . 'Polkurier/ParcelType.php');

require_once($polkurier_path . 'Polkurier/CollectionPoint/CollectionPointSql.php');
require_once($polkurier_path . 'Polkurier/CollectionPoint/CollectionPointModel.php');
require_once($polkurier_path . 'Polkurier/CollectionPoint/CollectionPoint.php');
require_once($polkurier_path . 'Polkurier/CollectionPoint/DeliveryPointAddressModule.php');

require_once($polkurier_path . 'Polkurier/Msg.php');
require_once($polkurier_path . 'Polkurier/Parcel/ParcelModel.php');
require_once($polkurier_path . 'ConfigApi.php');

require_once($polkurier_path . 'views/ViewAbstract.php');
require_once($polkurier_path . 'views/OrderView.php');
require_once($polkurier_path . 'views/ConfigParcelView.php');
require_once($polkurier_path . 'views/ConfigBankAccountView.php');
require_once($polkurier_path . 'views/ConfigAuthView.php');
require_once($polkurier_path . 'views/ConfigTemplateView.php');
require_once($polkurier_path . 'views/AdminConfigTopView.php');
require_once($polkurier_path . 'views/AdminConfigView.php');
require_once($polkurier_path . 'views/ConfigStatusOrderView.php');
require_once($polkurier_path . 'views/ConfigSenderPointView.php');
require_once($polkurier_path . 'views/ConfigSenderView.php');
require_once($polkurier_path . 'Polkurier/ConfigurationKey.php');
require_once($polkurier_path . 'Polkurier/CarriersList.php');

require_once($polkurier_path . 'sql/InstallSql.php');
require_once($polkurier_path . 'sql/UninstallSql.php');
