<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */


final class ConfigSenderPointView extends ViewAbstract
{
    /**
     * @return array
     */
    public static function getFormConfig()
    {
        return [
            'form' => [
                'legend' => [
                    'title' => 'Domyślne punkty nadawcze',
                    'icon' => 'icon-cogs',
                ],
                'input' => [
                    [
                        'type' => 'select',
                        'label' => 'Domyślny paczkomat nadawcy',
                        'name' => Polkurier\ConfigurationKey::POLKURIER_SENDER_POINT_INPOST_PACZKOMAT,
                        'id' => Polkurier\ConfigurationKey::POLKURIER_SENDER_POINT_INPOST_PACZKOMAT,
                        'desc' => 'Wpisz kod pocztowy, kod paczkomatu, nazwę miejscowości itp.',
                        'class' => 'select2',
                        'col' => 4,
                        'options' => [
                            'query' => self::getVariables('polkurier_sender_point_inpost_paczkomat')
                        ]
                    ],
                    [
                        'type' => 'select',
                        'label' => 'Domyślna palacówka pocztowa nadawcy',
                        'name' => Polkurier\ConfigurationKey::POLKURIER_SENDER_POINT_POCZTEX,
                        'id' => Polkurier\ConfigurationKey::POLKURIER_SENDER_POINT_POCZTEX,
                        'desc' => 'Wpisz kod pocztowy, kod placówki, nazwę miejscowości itp.',
                        'class' => 'select2',
                        'col' => 4,
                        'options' => [
                            'query' => self::getVariables('polkurier_sender_point_pocztex_punkt')
                        ]
                    ],
                    [
                        'type' => 'select',
                        'label' => 'Domyślny punkt DPD nadawcy',
                        'name' => Polkurier\ConfigurationKey::POLKURIER_SENDER_POINT_DPD,
                        'id' => Polkurier\ConfigurationKey::POLKURIER_SENDER_POINT_DPD,
                        'desc' => 'Wpisz kod pocztowy, kod punktu, nazwę miejscowości itp.',
                        'class' => 'select2',
                        'col' => 4,
                        'options' => [
                            'query' => self::getVariables('polkurier_sender_point_dpd')
                        ]
                    ],
                    [
                        'type' => 'select',
                        'label' => 'Domyślny punkt UPS nadawcy',
                        'name' => Polkurier\ConfigurationKey::POLKURIER_SENDER_POINT_UPS,
                        'id' => Polkurier\ConfigurationKey::POLKURIER_SENDER_POINT_UPS,
                        'desc' => 'Wpisz kod pocztowy, kod punktu, nazwę miejscowości itp.',
                        'class' => 'select2',
                        'col' => 4,
                        'options' => [
                            'query' => self::getVariables('polkurier_sender_point_ups')
                        ]
                    ]
                ],
                'submit' => [
                    'title' => 'Zapisz',
                ],
            ],
        ];
    }
}
