<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\ApiMetod;

use PolkurierWebServiceApi\Exception\ErrorException;
use PolkurierWebServiceApi\Methods\CancelOrder;
use Exception;

class CancelOrderApi extends ApiClient
{

    /**
     * @param $order
     * @return array
     * @throws Exception
     */
    public function cancelOrder($order)
    {
        if (!empty($order)) {
            try {
                $method = new CancelOrder();
                $method->setOrderNumber($order);
                $this->webApi()->requestMethod($method);
                return $method->getData();
            } catch (ErrorException $ex) {
                throw new Exception($ex->getMessage());
            }
        }
    }
}