<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\ApiMetod;

use Exception;
use PolkurierWebServiceApi\Exception\ErrorException;
use PolkurierWebServiceApi\Methods\GetStatus;

final class StatusOrderApi extends ApiClient
{
    /**
     * @param string $order_number
     * @return array|mixed
     * @throws Exception
     */
    public function getStatus($order_number = '')
    {
        if (!empty($order_number)) {
            try {

                $method = new GetStatus();
                $method->setOrderNumber($order_number);
                $this->webApi()->requestMethod($method);
                return $method->getData();

            } catch (ErrorException $ex) {
                throw new Exception($ex->getMessage());
            }
        }
    }
}