<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Bank;

/**
 * Lista kont bankowych dla zwrotu kwoty pobrania COD
 */
final class BankListModel
{
    /**
     * @var array
     */
    private static $list = [];

    /**
     * @var array
     */
    private static $list_option = [];

    /**
     * @param bool $refresh
     * @return array|false|\mysqli_result|\PDOStatement|resource|null
     */
    public static function getList($refresh = false)
    {
        if (empty(self::$list) || $refresh == true) {
            self::$list = BankModel::getBankList();
        }
        return self::$list;
    }

    /**
     * @param bool $refresh
     * @return array
     */
    public static function getListOption($refresh = false)
    {
        if (empty(self::$list_option) || $refresh == true) {
            self::$list_option = self::getBankOptions();
        }
        return self::$list_option;
    }

    /**
     * @param int $id
     * @return string|null
     */
    public static function getNumberAccountBank($id)
    {
        if (is_numeric($id)) {
            $row = BankModel::getBankById($id);
            return $row['iban'];
        }
        return null;
    }

    /**
     * @return array
     */
    private static function getBankOptions()
    {
        $result = [];
        $banklist = BankModel::getBankList();
        if (is_array($banklist)) {
            foreach ($banklist as $item) {
                $result[$item['bank_id']] = [
                    'id' => $item['bank_id'],
                    'name' => $item['name'] . ' - ' . $item['iban']
                ];
            }
        }
        return $result;
    }
}