<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Bank;

use Db;
use Polkurier\Model\SqlAbstract;
use PrestaShopDatabaseException;

class SqlBank extends SqlAbstract
{
    /**
     * @param array $data
     * @return int|string
     */
    public static function insertSql($data = [])
    {
        Db::getInstance()->insert(parent::BankAccount(), $data, false, false, Db::INSERT, false);
        return Db::getInstance()->Insert_ID();
    }
    
    /**
     * @param array $data
     * @param int $id
     * @return bool
     */
    public static function updateSql($data, $id)
    {
        return Db::getInstance()->update(parent::BankAccount(), $data, 'bank_id = ' . (int)$id, 0, false, false, false);
    }
    
    /**
     * @param int $id
     * @return array|bool|object|null
     */
    public static function getBankById($id)
    {
        try {
            return Db::getInstance()->getRow('SELECT * FROM ' . parent::BankAccount() . " WHERE bank_id = '" . (int)$id . "';");
        } catch (PrestaShopDatabaseException $e) {
            return [];
        }
    }
    
    /**
     * @return array|false|\mysqli_result|\PDOStatement|resource|null
     */
    public static function getBankList()
    {
        $result = [];
        try {
            $return = Db::getInstance()->executeS('SELECT * FROM ' . parent::BankAccount());
            if(is_array($return)){
                foreach ($return as $item) {
                    $result[$item['bank_id']] = $item;
                }
            }
        } catch (PrestaShopDatabaseException $e) {
        }
        return $result;
    }
    
    /**
     * @param int $id
     * @return bool
     */
    public static function deleteBankAccount($id)
    {
        if (!is_numeric($id)) {
            throw new Exception('Bank Id is empty ' . $id);
        }
        return Db::getInstance()->delete(parent::BankAccount(), 'bank_id=' . (int)$id, 1, false, false);
    }
}