<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 
 */

namespace Polkurier\Model;

use Country;
use Context;

final class CountryModel
{
    /**
     * @var array
     */
    private static $list = [];

    /**
     * @var array
     */
    private static $list_option = [];

    /**
     * @param bool $refresh
     * @return array
     */
    public static function getList($refresh = false)
    {
        if (empty(self::$list) || $refresh === true) {
            self::$list = Country::getCountries((int)Context::getContext()->cookie->id_lang, false, false, false);
        }
        return self::$list;
    }


    /**
     * @param bool $refresh
     * @return array
     *
     */
    public static function getListOption($refresh = false)
    {
        if (empty(self::$list_option) || $refresh === true) {
            self::$list_option = self::getCountryOptions();
        }
        return self::$list_option;
    }

    /**
     * @param int $idCountry
     * @return string
     */
    public static function getIsoById($idCountry)
    {
        return Country::getIsoById((int)$idCountry);
    }

    /**
     * @param int $idCountry
     * @return string
     */
    public static function getNameById($idCountry)
    {
        return Country::getNameById((int)Context::getContext()->cookie->id_lang, (int)$idCountry);
    }

    /**
     * @return array
     */
    private static function getCountryOptions()
    {
        $result = [];
        $list = self::getList();
        if (is_array($list)) {
            foreach ($list as $item) {
                $result[$item['id_country']] = [
                    'id' => $item['id_country'],
                    'name' => $item['name']
                ];
            }
        }
        return $result;
    }
}