<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 
 */

namespace Polkurier\Model;

use Polkurier\Bank\BankListModel;
use Polkurier\ConfigurationKey;
use Polkurier\Parcel\ParcelListModel;
use Polkurier\ParcelType;
use Polkurier\Sender\SenderListModel;
use Exception;
use Configuration;
use Polkurier\UpdateConfigPolkurierApi;

class PolkurierConfig extends Model
{
    /**
     * @var
     */
    private $instance;

    /**
     * @return PolkurierConfig
     */
    public static function getInstance()
    {
        if (!isset(self::$instance)) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    
    public static function init()
    {
        new UpdateConfigPolkurierApi();
        
        /* Lista zdefiniowanych szablonów paczek */
        self::ParcelList();
        
        /* lista zdefiniowanych adresów nadania */
        self::$sender_list = new SenderListModel();
        
        /*  Lista kont bankowych */
        self::BankList();
        
        self::getOptionCourierPickupType();
        
        self::loadCountries();
    }
    
    /**
     * PolkurierConfig constructor.
     * @throws \ReflectionException
     */
    public function __construct()
    {
        self::init();
    }
    
    /**
     * @param string $key
     * @param $val
     */
    public static function setConfigValue($key, $val)
    {
        Configuration::updateValue(strtoupper($key), $val);
        self::$config_value[strtoupper($key)] = $val;
    }
    
    /**
     * @param $key
     * @param bool $json
     * @return array|mixed|string
     */
    public static function getConfigValue($key)
    {
        if (!isset(self::$config_value[strtoupper($key)])) {
            self::$config_value[strtoupper($key)] = Configuration::get(strtoupper($key));
        }
        return self::$config_value[strtoupper($key)];
    }
    
    /**
     * Lista zdefiniowanych szablonów paczek
     */
    public static function ParcelList()
    {
        /* Rodzaj paczek */
        self::$shipment_type = ParcelType::getSelectList();
        
        /* lista paczek + lista do select */
        self::$parcel_template_list = new ParcelListModel();
    }
    
    /**
     * Lista kont bankowych
     */
    public static function BankList()
    {
        self::$bank_list = new BankListModel();
    }
    
    
    private static function loadCountries()
    {
        self::$countries = new CountryModel();
    }
    
    /**
     * @return array
     */
    public function toArray()
    {
        return get_object_vars($this);
    }
    
    /**
     * @throws Exception
     */
    public static function CheckIsDefined()
    {
        if (empty(self::getConfigValue(ConfigurationKey::POLKURIER_AUTH_API_TOKEN))) {
            throw new Exception("Polkurier moduł: Brak danych konfiguracyjnych API: token ");
        }
        
        if (empty(self::getConfigValue(ConfigurationKey::POLKURIER_AUTH_API_ACCOUNT))) {
            throw new Exception("Polkurier moduł: Brak danych konfiguracyjnych API: user id");
        }
    }
    
    
    public static function getOptionCourierPickupType()
    {
        self::$pickup_courier_type_option = [];
        foreach (self::$pickup_courier_type as $key => $val) {
            self::$pickup_courier_type_option[$key] = [
                "id" => $key,
                "name" => $val === true ? 'Podjazd kuriera' : 'Zamówię samodzielnie'
            ];
        }
    }
}
