<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Model\Shipment;

use Polkurier\CodReturnTime;
use Polkurier\CodType;

final class CodShipment
{
    /**
     * Sposób zwrotu pobrania
     * @var string
     */
    private $type = CodType::DEFAULT_TYPE;
    
    /**
     * Termin zwrotu pobrania
     * @var string
     */
    private $time = CodReturnTime::DEFAULT_TYPE;
    
    /**
     * Kwota pobrania
     * @var float
     */
    private $value = 0.00;
    
    /**
     * @var int
     */
    private $id_cod;
    
    /**
     * @var string
     */
    private $number;
    
    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    
    /**
     * @param string $type
     * @return $this
     */
    public function setType($type)
    {
        $this->type = (string)$type;
        return $this;
    }
    
    /**
     * @return string
     */
    public function getTime()
    {
        return $this->time;
    }
    
    /**
     * @param string $time
     * @return $this
     */
    public function setTime($time)
    {
        $this->time = (string)$time;
        return $this;
    }
    
    /**
     * @return float
     */
    public function getValue()
    {
        return $this->value;
    }
    
    /**
     * @param float $value
     * @return $this
     */
    public function setValue($value = 0.00)
    {
        $this->value = (float)$value;
        return $this;
    }
    
    /**
     * @return int
     */
    public function getIdCod()
    {
        return $this->id_cod;
    }
    
    /**
     * @param int $id_cod
     * @return $this
     */
    public function setIdCod($id_cod)
    {
        $this->id_cod = (int)$id_cod;
        return $this;
    }
    
    /**
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    
    /**
     * @param string $number
     * @return $this
     */
    public function setNumber($number)
    {
        $this->number = preg_replace('/\D/', '', (string)$number);
        return $this;
    }
}