<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */
namespace Polkurier\Model\Shipment;


abstract class OrderAdres
{
    /**
     * @var string|null
     */
    private $company;
    
    /**
     * @var string|null
     */
    private $firstname;
    
    /**
     * @var string|null
     */
    private $lastname;
    
    /**
     * @var string|null
     */
    private $street;
    
    /**
     * @var string|null
     */
    private $house_no;
    
    /**
     * @var string|null
     */
    private $flat_no;
    
    /**
     * @var string|null
     */
    private $postcode;
    
    /**
     * @var string|null
     */
    private $city;
    
    /**
     * @var int
     */
    private $country;
    
    /**
     * @var string|null
     */
    private $email;
    
    /**
     * @var string|null
     */
    private $phone;
    
    /**
     * numer paczkomatu/punktu
     * @var string|null
     */
    private $station;
    
    /**
     * @return string|null
     */
    public function getStation()
    {
        return $this->station;
    }
    
    /**
     * @param string|null $station
     * @return $this
     */
    public function setStation($station)
    {
        $this->station = (string)$station;
        return $this;
    }
    
    /**
     * @return string|null
     */
    public function getCompany()
    {
        return $this->company;
    }
    
    /**
     * @param string|null $company
     * @return $this
     */
    public function setCompany($company)
    {
        $this->company = (string)$company;
        return $this;
    }
    
    /**
     * @return string|null
     */
    public function getFirstname()
    {
        return (string)$this->firstname;
    }
    
    /**
     * @param string|null $firstname
     * @return $this
     */
    public function setFirstname($firstname)
    {
        $this->firstname = (string)$firstname;
        return $this;
    }
    
    /**
     * @return string|null
     */
    public function getLastname()
    {
        return $this->lastname;
    }
    
    /**
     * @param string|null $lastname
     * @return $this
     */
    public function setLastname($lastname)
    {
        $this->lastname = (string)$lastname;
        return $this;
    }
    
    /**
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    
    /**
     * @param string|null $street
     * @return $this
     */
    public function setStreet($street)
    {
        $this->street = (string)$street;
        return $this;
    }
    
    /**
     * @return string|null
     */
    public function getHouseNo()
    {
        return $this->house_no;
    }
    
    /**
     * @param string|null $house_no
     * @return $this
     */
    public function setHouseNo($house_no)
    {
        $this->house_no = (string)$house_no;
        return $this;
    }
    
    /**
     * @return string|null
     */
    public function getFlatNo()
    {
        return $this->flat_no;
    }
    
    /**
     * @param string|null $flat_no
     * @return $this
     */
    public function setFlatNo($flat_no)
    {
        $this->flat_no = (string)$flat_no;
        return $this;
    }
    
    /**
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    
    /**
     * @param string|null $postcode
     * @return $this
     */
    public function setPostcode($postcode)
    {
        $this->postcode = (string)$postcode;
        return $this;
    }
    
    /**
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    
    /**
     * @param string|null $city
     * @return $this
     */
    public function setCity($city)
    {
        $this->city = (string)$city;
        return $this;
    }
    
    /**
     * @return int|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    
    /**
     * @param int|null $country
     * @return $this
     */
    public function setCountry($country)
    {
        $this->country = (int)$country;
        return $this;
    }
    
    /**
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    
    /**
     * @param string|null $email
     * @return $this
     */
    public function setEmail($email)
    {
        $this->email = (string)$email;
        return $this;
    }
    
    /**
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    
    /**
     * @param string|null $phone
     * @return $this
     */
    public function setPhone($phone)
    {
        $this->phone = (string)$phone;
        return $this;
    }
    
    /**
     * @return string
     */
    public function getPerson()
    {
        return trim($this->getFirstname() . ' ' . $this->getLastname());
    }
}