<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 
 */

namespace Polkurier\Model\Shipment;

class ShipmentAdditionalServices
{
    const SMS_NOTIFICATION_RECIPIENT = 'SMS_NOTIFICATION_RECIPIENT';
    const COURIER_PRINTED_LABEL = 'COURIER_PRINTED_LABEL';
    const COURIER_WEEK_COLLECTION = 'COURIER_WEEK_COLLECTION';

    /**
     * @var array
     */
    private $services = [];

    /**
     * @return string[]
     */
    public function getServices()
    {
        return $this->services;
    }

    /**
     * @param string $services
     */
    public function setServices($services)
    {
        $this->services[] = $services;
    }

    /**
     * @param $services
     * @return bool
     */
    public function isServices($services)
    {
        return in_array($services, $this->services, true);
    }
}