<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace PolkurierWebServiceApi\Entities;

use PolkurierWebServiceApi\Type\PackType;

class ShipmentModelPack
{
    /**
     * @var float
     */
    private $length = 0;
    
    /**
     * @var float
     */
    private $width = 0;
    
    /**
     * @var float
     */
    private $height = 0;
    
    /**
     * @var float
     */
    private $weight = 0;
    
    /**
     * @var float
     */
    private $amount = 1;
    
    /**
     * @var string
     */
    private $type = PackType::ST;
    
    /**
     * @return float
     */
    public function getLength()
    {
        return $this->length;
    }
    
    /**
     * @param $length
     * @return $this
     */
    public function setLength($length)
    {
        $this->length = (float)$length;
        return $this;
    }
    
    /**
     * @return float
     */
    public function getWidth()
    {
        return $this->width;
    }
    
    /**
     * @param float $width
     * @return Pack
     */
    public function setWidth($width)
    {
        $this->width = (float)$width;
        return $this;
    }
    
    /**
     * @return float
     */
    public function getHeight()
    {
        return $this->height;
    }
    
    /**
     * @param float $height
     * @return $this
     */
    public function setHeight($height)
    {
        $this->height = (float)$height;
        return $this;
    }
    
    /**
     * @return float
     */
    public function getWeight()
    {
        return $this->weight;
    }
    
    /**
     * @param float $weight
     * @return $this
     */
    public function setWeight($weight)
    {
        $this->weight = (float)$weight;
        return $this;
    }
    
    /**
     * @return int
     */
    public function getAmount()
    {
        return $this->amount;
    }
    
    /**
     * @param int $amount
     * @return $this
     */
    public function setAmount($amount)
    {
        $this->amount = (int)$amount;
        return $this;
    }
    
    /**
     * @return mixed
     */
    public function getType()
    {
        return $this->type;
    }
    
    /**
     * @param mixed $type
     * @return $this
     */
    public function setType($type)
    {
        $this->type = $type;
        return $this;
    }
    
    /**
     * @return array
     */
    public function toArray()
    {
        return [
            'length' => $this->length,
            'width' => $this->width,
            'height' => $this->height,
            'weight' => $this->weight,
            'amount' => $this->amount,
            'type' => $this->type
        ];
    }
    
}