<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier;

final class Msg
{
    /**
     * @var array
     */
    private $errors = [];
    /**
     * @var array
     */
    private $confirmations = [];

    public function setErrors($errors)
    {
        $this->errors[] = (string)$errors;
    }

    public function setConfirmations($confirmations)
    {
        $this->confirmations[] = (string)$confirmations;
    }
    
    /**
     * @return array
     */
    public function getErrors()
    {
        return $this->errors;
    }
    
    /**
     * @return array
     */
    public function getConfirmations()
    {
        return $this->confirmations;
    }
}