<?php

/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Parcel;

final class ParcelListModel extends ParcelModel
{
    /**
     * @var array
     */
    private static $list = [];
    
    /**
     * @var array
     */
    private static $list_option = [];
    
    /**
     * @param bool $refresh
     * @return array|false|\mysqli_result|\PDOStatement|resource|null
     */
    public static function getList($refresh = false)
    {
        if (empty(self::$list) || $refresh === true) {
            self::$list = parent::getParcelTemplateList();
        }
        return self::$list;
    }
    
    /**
     * @param bool $refresh
     * @return false|string
     */
    public static function getListToJson($refresh = false)
    {
        if (empty(self::$list) || $refresh === true) {
            self::$list = parent::getParcelTemplateList();
        }
        return json_encode(self::$list);
    }
    
    /**
     * @param bool $refresh
     * @return array
     *
     */
    public static function getListOption($refresh = false)
    {
        if (empty(self::$list_option) || $refresh === true) {
            self::$list_option = self::getParcelOptions();
        }
        return self::$list_option;
    }
    
    /**
     * @param bool $refresh
     * @return false|string
     */
    public static function getListOptionToJson($refresh = false)
    {
        if (empty(self::$list_option) || $refresh === true) {
            self::$list_option = self::getParcelOptions();
        }
        return json_encode(self::$list_option);
    }
    
    /**
     * @return array
     */
    private static function getParcelOptions()
    {
        $result = [];
        $list = self::getList();
        if(is_array($list)){
            foreach ($list as $item) {
                $result[$item['parcel_id']] = [
                    'id' => $item['parcel_id'],
                    'name' => $item['name']
                ];
            }
        }
        return $result;
    }
}