<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier;

use PolkurierWebServiceApi\Type\ShipmentType;

final class ParcelType
{
    /**
     * @var array
     */
    private static $listname = [
        ShipmentType::ENVELOPE => 'Koperta',
        ShipmentType::BOX => 'Paczka',
        ShipmentType::PALETTE => 'Paleta'
    ];
    
    /**
     * @return array
     */
    public static function getSelectList()
    {
        return [
            ShipmentType::ENVELOPE => [
                'id' => ShipmentType::ENVELOPE,
                'name' => 'Koperta',
                'default' => false
            ],
            ShipmentType::BOX => [
                'id' => ShipmentType::BOX,
                'name' => 'Paczka',
                'default' => true
            ],
            ShipmentType::PALETTE => [
                'id' => ShipmentType::PALETTE,
                'name' => 'Paleta',
                'default' => false
            ]
        ];
    }
    
    /**
     * @return array
     */
    public static function getSelectList2()
    {
        return self::$listname;
    }
    
    /**
     * @param string $value
     * @return string
     */
    public static function getName($value)
    {
        if (!empty($value) && isset(self::$listname[$value])) {
            return self::$listname[$value];
        }
    }
}