<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

namespace Polkurier\Sender;

use Db;
use Exception;
use Polkurier\Model\SqlAbstract;

class SqlSender extends SqlAbstract
{
    
    /**
     * @param array $data
     * @return int|string
     */
    public static function insertSql($data = [])
    {
        Db::getInstance()->insert(parent::Sender(), $data, false, false, Db::INSERT, false);
        return Db::getInstance()->Insert_ID();
    }
    
    /**
     * @param array $data
     * @param int $id
     * @return bool
     */
    public static function updateSql($data, $id)
    {
        return Db::getInstance()->update(parent::Sender(), $data, 'sender_id = ' . (int)$id, 0, false, false, false);
    }
    
    
    /**
     * @return array|false|\mysqli_result|\PDOStatement|resource|null
     */
    public static function getAllSender()
    {
        $sql = "SELECT * FROM " . parent::Sender();
        return Db::getInstance()->executeS($sql, true, true);
    }
    
    
    /**
     * @param int $id
     * @return array|bool|object|null
     */
    public static function getSenderById($id)
    {
        try {
            $sql = 'SELECT * FROM ' . self::Sender() . ' WHERE sender_id = ' . (int)$id . ';';
            return Db::getInstance()->getRow($sql);
        } catch (PrestaShopDatabaseException $e) {
            return [];
        }
    }
    
    
    /**
     * @param $id
     * @return bool
     * @throws \Exception
     */
    public static function deleteSender($id)
    {
        if (!is_numeric($id)) {
            throw new Exception('Sender Id is empty ' . $id);
        }
        return Db::getInstance()->delete(parent::Sender(), 'sender_id=' . (int)$id, 1, false, false);
    }
}