<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

use Polkurier\ApiMetod\LabelOrderApi;
use Polkurier\ApiMetod\PickupCourierApi;
use Polkurier\ApiMetod\ProtocolOrderApi;
use Polkurier\Order\CreateNewOrder;
use Polkurier\Order\OrderPolkurier;
use Polkurier\Order\OrderValuation;
use Polkurier\Order\RefreshOrderStatusPolkurier;
use Polkurier\ApiMetod\CourierPointApi;

class AdminPolkurierModuleController extends ModuleAdminController
{
    /**
     * @var array
     */
    private $return = [
        'status' => true,
        'error' => '',
        'data' => ''
    ];

    public function __construct()
    {
        parent::__construct();
        $this->display_header = false;
        $this->bootstrap = true;
        $this->ajax = true;
        $this->context->smarty->assign([
            'shop_name' => Configuration::get('PS_SHOP_NAME'),
            'img_dir' => _PS_IMG_,
            'iso' => $this->context->language->iso_code,
            'bootstrap' => 1,
            'currency_symbol' => $this->context->currency->sign,
        ]);
    }

    /**
     * @return mixed
     */
    private function JsonResponse()
    {
        die(json_encode($this->return));
    }

    /**
     * Wycena zamówienia
     * @return mixed
     * @throws \ReflectionException
     */
    public function ajaxProcessvaluationorder()
    {
        try {

            $order_valuation = new OrderValuation();
            parse_str(Tools::getValue('data_form', []), $output);
            $order_valuation->setDataform($output);
            $this->return['data'] = $order_valuation->Valuation();

        } catch (Exception $ex) {

            $this->return['error'] = $ex->getMessage();
            $this->return['status'] = false;
        }

        return $this->JsonResponse();
    }


    public function ajaxProcesscourierpoint()
    {
        try {

            $this->return['data'] = [];

            $searchquery = Tools::getValue('searchquery', null);
            if (!is_null($searchquery)) {
                $courier_point_api = new CourierPointApi();

                foreach (Tools::getValue('functions', []) as $item) {
                    $courier_point_api->setFunctions($item);
                }

                foreach (Tools::getValue('couriers', []) as $item) {
                    $courier_point_api->setCouriers($item);
                }

                $courier_point_api->setSearchQuery($searchquery);
                $point = $courier_point_api->getPoint();
                if(!empty($point)){
                    $this->return['data'] = array_map(function ($point) {
                        return ['id' => $point['id'], 'city' => $point['city'], 'street' => $point['street'],'zip' => $point['zip']];
                    }, $courier_point_api->getPoint());
                }
            }

        } catch (Exception $ex) {
            $this->return['error'] = $ex->getMessage();
            $this->return['status'] = false;
        }

        return $this->JsonResponse();
    }


    /**
     * Pickup
     * @return mixed
     */
    public function ajaxProcesspickup()
    {
        try {

            $pickupcourierapi = new PickupCourierApi();
            $pickupcourierapi->setParcel(Tools::getValue('parcel', null));
            $pickupcourierapi->setPickupDate(Tools::getValue('pickup_date', null));
            $pickupcourierapi->setShipForm(Tools::getValue('postal_code', null));
            $pickupcourierapi->setCourier(Tools::getValue('service_code', null));
            $this->return['data'] = $pickupcourierapi->getPickup();

        } catch (Exception $ex) {
            $this->return['error'] = $ex->getMessage();
            $this->return['status'] = false;
        }

        return $this->JsonResponse();
    }

    /**
     * Nowe zlecenie
     * @return mixed
     */
    public function ajaxProcessorder()
    {
        try {

            $createneworder = new CreateNewOrder();
            parse_str(Tools::getValue('data_form', []), $output);
            $createneworder->setDataform($output);
            $this->return['data'] = $createneworder->newOrder();

        } catch (Exception $ex) {

            $this->return['error'] = $ex->getMessage();
            $this->return['status'] = false;
        }
        return $this->JsonResponse();
    }

    /**
     * @return array
     */
    private function getNumberOrder()
    {
        $number_order = [];
        if (!is_null(Tools::getValue('idorder', null))) {
            $idorder = explode(',', Tools::getValue('idorder'));
            $orderclass = new OrderPolkurier();
            foreach ($idorder as $item) {
                if (is_numeric($item)) {
                    $order = $orderclass->getOrderById((int)$item);
                    if (is_numeric($order['order_id']) && !empty($order['number_order'])) {
                        $number_order[] = $order['number_order'];
                    }
                }
            }
        }
        return $number_order;
    }

    /**
     * Odwieżenie statusu przesyłek
     */
    public function ajaxProcessrefreshorderstatus()
    {
        (new RefreshOrderStatusPolkurier())->Refresh();
    }


    /**
     * Etykiety
     */
    public function ajaxProcessgetlabel()
    {
        $number_order = $this->getNumberOrder();

        if (!empty($number_order)) {

            try {

                $labelorderapi = new LabelOrderApi();
                foreach ($number_order as $item) {
                    $labelorderapi->setOrderNumber($item);
                }
                $file_pdf = $labelorderapi->getLabel();

                if (!empty($file_pdf)) {

                    if (count($number_order) === 1) {
                        $filename = 'etykieta_' . $number_order[0];
                    } else {
                        $filename = 'etykieta_' . date('Y_m_d_H_i');
                    }
                    $this->getAttachment($filename, $file_pdf);
                }

            } catch (Exception $ex) {
            }
        }
    }


    /**
     * Protokol nadania
     */
    public function ajaxProcessgetprotocol()
    {
        $number_order = $this->getNumberOrder();

        if (!empty($number_order)) {

            try {

                $protocolorderapi = new ProtocolOrderApi();
                foreach ($number_order as $item) {
                    $protocolorderapi->setOrderNumber($item);
                }
                $file_pdf = $protocolorderapi->getProtocol();

                if (!empty($file_pdf)) {

                    if (count($number_order) === 1) {
                        $filename = 'protokol_wydania_' . $number_order[0];
                    } else {
                        $filename = 'protokol_wydania_' . date('Y_m_d_H_i');
                    }
                    $this->getAttachment($filename, $file_pdf);
                }
            } catch (Exception $ex) {
            }
        }
    }

    /**
     * @param string $filename
     * @param string $bin
     */
    private function getAttachment($filename, $bin)
    {
        header('Content-Type: application/pdf');
        header("Content-Disposition: attachment; filename=$filename.pdf");
        header('Cache-Control: private, max-age=0, must-revalidate');
        header('Pragma: public');
        header("Content-Length: " . strlen($bin));
        echo $bin;
        exit();
    }
}