<?php

namespace Sql;
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

use Db;

class InstallSql
{

    public static function Install()
    {
        $sql = [];

        $sql[] = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'pk_bank` (
                  `bank_id` int(10) NOT NULL AUTO_INCREMENT,
                  `name` varchar(100) DEFAULT NULL,
                  `iban` varchar(30) NOT NULL DEFAULT \'\',
                  PRIMARY KEY (`bank_id`)
                ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=utf8;';


        $sql[] = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'pk_orders` (
              `order_id` int(10) NOT NULL AUTO_INCREMENT,
              `id_order_presta` int(12) NOT NULL,
              `number_order` varchar(50) DEFAULT NULL,
              `number_label` varchar(50) NOT NULL DEFAULT \'\',
              `shipment_type` varchar(20) DEFAULT NULL,
              `service_code` varchar(20) DEFAULT NULL,
              `content` varchar(50) DEFAULT NULL,
              `cod_shipment` double(10,2) DEFAULT \'0.00\',
              `number_account_bank` varchar(50) DEFAULT NULL,
              `return_cod_type` varchar(10) DEFAULT NULL,
              `return_cod_time` varchar(10) DEFAULT NULL,
              `insurance` double(10,2) DEFAULT \'0.00\',
              `order_price_gross` double(5,2) DEFAULT \'0.00\',
              `order_price_net` double(5,2) DEFAULT \'0.00\',
              `status` varchar(256) NOT NULL DEFAULT \'\',
              `traking_url` varchar(256) DEFAULT \'\',
              `status_date` datetime DEFAULT NULL,
              `delivered_date` date DEFAULT NULL,
              `sended_date` varchar(50) DEFAULT NULL,
              `created_date` datetime DEFAULT NULL,
              `cancel_order` tinyint(1) DEFAULT NULL,
              PRIMARY KEY (`order_id`),
              KEY `id_order_presta` (`id_order_presta`)
            ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=utf8;';


        $sql[] = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'pk_order_parcel` (
                  `parcel_id` int(10) NOT NULL AUTO_INCREMENT,
                  `order_id` int(10) DEFAULT \'0\',
                  `count` tinyint(4) NOT NULL DEFAULT \'0\',
                  `no_std` int(1) NOT NULL DEFAULT \'0\',
                  `weight` double(5,2) NOT NULL DEFAULT \'0.00\',
                  `length` double(5,2) NOT NULL DEFAULT \'0.00\',
                  `height` double(5,2) NOT NULL DEFAULT \'0.00\',
                  `width` double(5,2) NOT NULL DEFAULT \'0.00\',
                  PRIMARY KEY (`parcel_id`),
                  KEY `order_id` (`order_id`)
                ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=utf8;';


        $sql[] = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'pk_order_receiver` (
                  `receiver_id` int(10) NOT NULL AUTO_INCREMENT,
                  `order_id` int(11) NOT NULL,
                  `company` varchar(50) DEFAULT NULL,
                  `first_name` varchar(50) DEFAULT NULL,
                  `last_name` varchar(50) DEFAULT NULL,
                  `street` varchar(50) NOT NULL,
                  `house_no` varchar(10) DEFAULT NULL,
                  `flat_no` varchar(10) DEFAULT NULL,
                  `postcode` varchar(20) NOT NULL,
                  `city` varchar(50) NOT NULL,
                  `country_id` int(11) NOT NULL,
                  `email` varchar(100) DEFAULT NULL,
                  `phone` varchar(20) DEFAULT NULL,
                  `machine_name` varchar(20) DEFAULT NULL,
                  PRIMARY KEY (`receiver_id`) USING BTREE,
                  KEY `order_id` (`order_id`)
                ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=utf8;';


        $sql[] = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'pk_order_sender` (
                  `receiver_id` int(10) NOT NULL AUTO_INCREMENT,
                  `order_id` int(11) NOT NULL,
                  `company` varchar(50) DEFAULT NULL,
                  `first_name` varchar(50) DEFAULT NULL,
                  `last_name` varchar(50) DEFAULT NULL,
                  `street` varchar(50) NOT NULL,
                  `house_no` varchar(10) DEFAULT NULL,
                  `flat_no` varchar(10) DEFAULT NULL,
                  `postcode` varchar(20) NOT NULL,
                  `city` varchar(50) NOT NULL,
                  `contact_name` varchar(50) DEFAULT NULL,
                  `email` varchar(50) DEFAULT NULL,
                  `phone` varchar(20) DEFAULT NULL,
                  `machine_name` varchar(20) DEFAULT NULL,
                  PRIMARY KEY (`receiver_id`) USING BTREE,
                  KEY `order_id` (`order_id`)
                ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=utf8;';


        $sql[] = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'pk_parcel` (
                  `parcel_id` int(10) NOT NULL AUTO_INCREMENT,
                  `name` varchar(50) DEFAULT NULL,
                  `shipment_type` varchar(10) DEFAULT \'box\',
                  `quantity` tinyint(4) DEFAULT \'0\',
                  `nstd` int(1) DEFAULT \'0\',
                  `content` varchar(40) DEFAULT \'\',
                  `weight` decimal(5,2) DEFAULT \'0.00\',
                  `dim_1` decimal(5,2) DEFAULT \'0.00\',
                  `dim_2` decimal(5,2) DEFAULT \'0.00\',
                  `dim_3` decimal(5,2) DEFAULT \'0.00\',
                  PRIMARY KEY (`parcel_id`)
                ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=utf8;';


        $sql[] = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'pk_sender` (
                  `sender_id` int(10) NOT NULL AUTO_INCREMENT,
                  `name` varchar(50) NOT NULL,
                  `company` varchar(100) DEFAULT NULL,
                  `first_name` varchar(50) DEFAULT NULL,
                  `last_name` varchar(50) DEFAULT NULL,
                  `street` varchar(50) DEFAULT NULL,
                  `house_no` varchar(10) DEFAULT NULL,
                  `flat_no` varchar(10) DEFAULT NULL,
                  `postcode` varchar(20) DEFAULT NULL,
                  `city` varchar(100) DEFAULT NULL,
                  `contact_name` varchar(100) DEFAULT NULL,
                  `email` varchar(100) DEFAULT NULL,
                  `phone` varchar(20) DEFAULT NULL,
                  PRIMARY KEY (`sender_id`)
                ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=utf8;';

        foreach ($sql as $query) {
            if (!Db::getInstance()->execute($query)) {
                return false;
            }
        }
        if (!self::update110()) {
            return false;
        }

        return true;
    }

    /**
     * @return bool
     */
    public static function update110()
    {
        $sql = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'pk_collection_point`(
    		      `id` int(11) NOT NULL AUTO_INCREMENT,
                  `id_cart` int(11) NOT NULL,
                  `providers` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
                  `collection_point` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
                  `adres` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
                  PRIMARY KEY (`id`)
                  )ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=utf8;';
        return Db::getInstance()->execute($sql);
    }
}