<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

class ConfigParcelView extends ViewAbstract
{
    /**
     * @var string
     */
    protected static $template = '/views/templates/admin/parcel_form.tpl';
    
    /**
     * @return string
     */
    public static function getTemplate()
    {
        return self::$template;
    }
    
    /**
     * @return array
     */
    public static function getFormConfig()
    {
        return [
            'form' => [
                'legend' => [
                    'title' => 'Szablony paczek',
                ],
                'input' => [
                    [
                        'type' => 'hidden',
                        'name' => 'parcel_id'
                    ],
                    [
                        'type' => 'text',
                        'label' => 'Nazwa na liście',
                        'name' => 'name',
                        'maxlength' => 50,
                        'class' => 'form-control',
                        'col' => 3,
                    ],
                    [
                        'type' => 'select',
                        'label' => 'Typ Przesyłki',
                        'name' => 'shipment_type',
                        'col' => 3,
                        'class' => 'form-control',
                        'options' => [
                            'query' => self::getVariables('shipment_type'),
                            'id' => 'id',
                            'name' => 'name'
                        ]
                    ],
                    [
                        'type' => 'text',
                        'label' => 'Domyślna informacja o wysyłce',
                        'name' => 'content',
                        'id' => 'order_content',
                        'maxlength' => 40,
                        'col' => 3,
                        'class' => 'form-control',
                    ],
                    [
                        'type' => 'radio',
                        'col' => 3,
                        'label' => 'Przesyłka Niestandardowa',
                        'name' => 'nstd',
                        'class' => 'radio-inline',
                        'values' => [
                            [
                                'id' => 'nstd_1',
                                'value' => 1,
                                'label' => 'Tak'
                            ],
                            [
                                'id' => 'nstd_0',
                                'value' => 0,
                                'label' => 'Nie'
                            ]
                        ]
                    ],
                    [
                        'type' => 'text',
                        'label' => 'Domyślna waga',
                        'name' => 'weight',
                        'maxlength' => 5,
                        'suffix' => 'KG',
                        'col' => 3,
                    ],
                    [
                        'type' => 'text',
                        'label' => 'Długość',
                        'name' => 'dim_1',
                        'maxlength' => 4,
                        'suffix' => 'CM',
                        'col' => 3,
                    ],
                    [
                        'type' => 'text',
                        'label' => 'Szerokość',
                        'name' => 'dim_2',
                        'maxlength' => 4,
                        'suffix' => 'CM',
                        'col' => 3,
                    ],
                    [
                        'type' => 'text',
                        'label' => 'Wysokość',
                        'name' => 'dim_3',
                        'maxlength' => 4,
                        'suffix' => 'CM',
                        'col' => 3,
                        
                    ],
                    [
                        'type' => 'text',
                        'label' => 'Ilość paczek',
                        'name' => 'quantity',
                        'data' => 1,
                        'maxlength' => 2,
                        'col' => 3,
                    ],
                ],
                'submit' => [
                    'title' => 'Zapisz',
                    'class' => 'button pull-right',
                ]
            ]
        ];
    }
}
