<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

final class ConfigStatusOrderView extends ViewAbstract
{
    /**
     * @return array
     */
    public static function getFormConfig()
    {
        return [
            'form' => [
                'legend' => [
                    'title' => 'Status zamówienia',
                    'icon' => 'icon-cogs',
                ],
                'input' => [
                    [
                        'type' => 'switch',
                        'label' => 'Zmień status zamówienia po nadaniu przesyłki',
                        'name' => Polkurier\ConfigurationKey::POLKURIER_SET_ORDER_NEW_SHIPMENT,
                        'values' => [
                            [
                                'value' => 1,
                                'label' => 'TAK'
                            ],
                            [
                                'value' => 0,
                                'label' => 'NIE'
                            ]
                        ]
                    ],
                    [
                        'type' => 'select',
                        'label' => 'Status zamówienia po nadaniu przesyłki',
                        'name' => Polkurier\ConfigurationKey::POLKURIER_STATUS_ORDER_NEW_SHIPMENT,
                        'class' => 'select2',
                        'col' => 3,
                        'options' => [
                            'query' => self::getVariables('order_status'),
                            'id' => 'id_order_state',
                            'name' => 'name'
                        ]
                    ],
                    [
                        'type' => 'switch',
                        'label' => 'Zmień status zamówienia po dostarczeniu przesyłki',
                        'name' => Polkurier\ConfigurationKey::POLKURIER_SET_ORDER_STATUS_SHIPMENT,
                        'values' => [
                            [
                                'value' => 1,
                                'label' => 'TAK'
                            ],
                            [
                                'value' => 0,
                                'label' => 'NIE'
                            ]
                        ]
                    ],
                    [
                        'type' => 'select',
                        'label' => 'Status zamówienia po dostarczeniu przesyłki',
                        'name' => Polkurier\ConfigurationKey::POLKURIER_STATUS_ORDER_STATUS_SHIPMENT,
                        'desc' => 'Funkcja aktywna między innymi kiedy klikniesz w "ODŚWIEŻ STATUSY" na liście przysyłek kurierskich ',
                        'class' => 'select2',
                        'col' => 3,
                        'options' => [
                            'query' => self::getVariables('order_status'),
                            'id' => 'id_order_state',
                            'name' => 'name'
                        ]
                    ]
                ],
                'submit' => [
                    'title' => 'Zapisz',
                ],
            ],
        ];
    }
}
