<?php
/**
 * @author     polkurier.pl <api@polkurier.pl>
 * @copyright  polkurier.pl
 * @license    https://opensource.org/licenses/OSL-3.0 OSL/OSL-3.0
 * @category   Module
 * @package    Presta 1.7
 * @subpackage polkurier
 * @link       https://www.polkurier.pl
 */

abstract class ViewAbstract
{
    /**
     * @var array
     */
    protected static $variables = [];

    /**
     * @return array
     */
    protected static function getVariables($key)
    {
        if (isset(self::$variables[$key])) {
            return self::$variables[$key];
        }
    }

    /**
     * @param string $key
     * @param mixed $variable
     */
    public static function setVariables($key, $variable)
    {
        self::$variables[$key] = $variable;
    }
}