import {toggleButtonBusyState} from '../esm/custom-elements/pk-spinner.js?ver=2.5.1';

document.body.addEventListener('click', async (e) => {
    const button = e.target.closest('.wc-action-button-polkurier-quick');
    if (button) {
        e.preventDefault();

        const orderId = new URL(e.target.href).searchParams.get('order_id');
        if (!orderId) {
            return;
        }

        toggleButtonBusyState(button, true);
        try {
            await import('./pk-quick-order-view.js?ver=2.5.1');
            const view = document.createElement('pk-quick-order-view');
            view.orderId = orderId;

            view.addEventListener('closed', () => {
                document.body.removeChild(view);
            });

            view.addEventListener('createorder', (e) => {
                const order = e.detail;
                const container = document.getElementById(`pk-order-${orderId}-tracking`);
                if (container && order) {
                    container.innerHTML = `
                        <div>
                            <a href="https://www.polkurier.pl/lista-zamowien?numer-zamowienia=${order.order_number}" target="_blank">
                                ${order.order_number}
                            </a>
                        </div>
                        ${order.label && Array.isArray(order.label) ? `
                            <div>
                                ${order.label.map(label => `
                                    <a href="https://www.polkurier.pl/sledzenie-przesylek?number=${label}" target="_blank">
                                        ${label}
                                    </a>
                                `).join('')}
                            </div>
                        ` : null}
                    `;
                }
            });

            document.body.appendChild(view);
        } catch (e) {
            console.error(e);
        }
        toggleButtonBusyState(button, false);
    }
});
