import {html, LitElement} from "../esm/libs/lit.dist.js?ver=2.5.1";
import styles from '../esm/custom-elements/styles.css.js?ver=2.5.1';
import {formatCurrency, numberFilter} from "../esm/util/numbers.js?ver=2.5.1";

export class PkQuickOrderInsuranceEditView extends LitElement {

    static properties = {
        value: {type: Number},
    };

    static styles = styles;

    onClickCancelButton() {
        this.dispatchEvent(new CustomEvent('cancel'));
    }

    onClickAcceptButton() {
        this.dispatchEvent(new CustomEvent('confirm'));
    }

    render() {
        return html`
            <div class="d-flex-column gap">
                <div>
                    <label class="pk-label">
                        <strong>Wartość ubezpieczenia</strong>
                        <input
                            class="pk-input"
                            placeholder="0,00"
                            .value="${this.value ? formatCurrency(this.value) : ''}"
                            @change="${e => this.value = numberFilter(e.target.value)}"
                        >
                    </label>
                </div>
                <div class="d-flex gap-sm mt" style="justify-content: end;">
                    <button class="btn" @click="${this.onClickCancelButton}">Anuluj</button>
                    <button class="btn btn-primary" @click="${this.onClickAcceptButton}">Zatwierdź</button>
                </div>
            </div>
        `;
    }
}

customElements.define("pk-quick-order-insurance-edit-view", PkQuickOrderInsuranceEditView);
