import {html, css, LitElement} from "../libs/lit.dist.js?ver=2.5.1";

export class PkBadge extends LitElement {


    static styles = css`
        :host {
            display: inline-flex;
            padding: var(--padding-y, 0.25rem) var(--padding-x, 0.6rem);
            border-radius: 1.2rem;
            line-height: 1rem;
            background-color: var(--background-color, var(--pk-gray-200));
            color: var(--text-color, var(--pk-gray-900));
            gap: 0.7rem;
            align-items: center;
        }
        
        :host([size="small"]),
        :host([size="sm"]) {
            --padding-y: 0.1rem;
            --padding-x: 0.5rem;
            font-size: 0.6rem;
        }
        
        :host([size="medium"]),
        :host([size="md"])  {
            --padding-y: 0.5rem;
            --padding-x: 1.2rem;
        }
        
        :host([type="warning"]),
        :host([warning]) {
            --background-color: var(--pk-yellow-500);
        }
        
        :host([type="success"]),
        :host([success]) {
            --background-color: var(--pk-green-500);
            --text-color: white;
        }
                
        :host([type="danger"]),
        :host([danger]) {
            --background-color: var(--pk-red-600);
            --text-color: white;
        }
                        
        :host([type="info"]),
        :host([info]) {
            --background-color: var(--pk-blue-100);
        }
                                
        :host([type="primary"]),
        :host([primary]) {
            --background-color: var(--pk-primary-500);
            --text-color: var(--white);
        }
                                        
        :host([type="secondary"]),
        :host([secondary]) {
            --background-color: var(--pk-gray-300);
        }
                                                
        :host([type="dark"]),
        :host([dark]) {
            --background-color: var(--pk-gray-900);
            --text-color: white;
        }        
                                                        
        :host([type="light"]),
        :host([dark]) {
            --background-color: var(--pk-gray-100);
        }        
                                                                
        :host([type="code"]) {
            --background-color: var(--pk-red-200);
            --text-color: var(--pk-red-600);
        }        
        
        :host([type="unstyled"]),
        :host([unstyled]) {
            --background-color: transparent;
            --padding-y: 0;
            --padding-x: 0;
        }
    `

    render() {
        return html`
            <slot name="before"></slot>
            <slot></slot>
            <slot name="after"></slot>
        `;
    }
}

customElements.define('pk-badge', PkBadge);
