import {css} from "../libs/lit.dist.js?ver=2.5.1";

export default css`
    * {
        box-sizing: border-box;
    }

    :host {
        --z-index: 9999;
        --border-radius: 0.5rem;
        --header-padding-y: 1.25rem;
        --header-padding-x: 1.5rem;
        --margin-top: 3rem;
    }

    .modal {
        position: fixed;
        top: 0;
        left: 0;
        z-index: var(--z-index);
        width: 100%;
        height: 100%;
        overflow-x: hidden;
        overflow-y: auto;
        background-color: rgba(0, 0, 0, 0);
        transition: background-color 0.3s,
                    opacity 0.2s;
        opacity: 0;
    }

    :host(.opened) .modal {
        opacity: 1;
        transition: background-color 0.3s,
                    opacity 0.2s;
        background-color: rgba(0, 0, 0, 0.2);
    }

    .modal-dialog {
        position: relative;
        width: auto;
        margin: 0.5rem;
        pointer-events: auto;
        transform: translateY(-4rem);
        transition: transform 0.3s ease-out;
    }

    .modal-dialog-right {
        position: absolute;
        top: 0;
        right: 0;
        width: 100%;
        height: 100%;
        margin: 0 !important;
        border-width: 0;
        transform: translateX(30%);
        --border-radius: 0;

        .modal-content {
            min-height: 100%;
        }
        
        .dialog-header {
            position: sticky;
            top: 0;
            z-index: var(--z-index);
        }
    }
    
    .modal-with-header .modal-body {
        padding-top: 0;
    }

    :host(.opened) .modal-dialog {
        transform: translateY(0);

        &.modal-dialog-right {
            transform: translateX(0);
        }
    }

    .modal-content {
        position: relative;
        display: flex;
        flex-direction: column;
        width: 100%;
        background-color: #fff;
        background-clip: padding-box;
        border: 0 none;
        outline: 0;
        box-shadow: 0 0 20px 0 rgba(0, 0, 0, 0.2);
        border-radius: var(--border-radius);
    }

    .dialog-header {
        display: flex;
        align-items: center;
        width: 100%;
        padding: var(--header-padding-y) var(--header-padding-x);
        background: transparent;
        color: black;
        margin-bottom: 0;
        font-size: 0.75rem;
        white-space: nowrap;
        line-height: 1.3;
        font-weight: 400;
        border-radius: var(--border-radius) var(--border-radius) 0 0;
    }

    .modal-body {
        position: relative;
        flex: 1 1 auto;
        padding: var(--modal-body-padding, 1.25rem);
    }

    .dialog-title {
        font-size: 0.9375rem;
        font-weight: normal;
        margin: 0;
    }

    .dialog-controls {
        margin-left: auto;
        display: flex;
        align-items: center;
        gap: 0.75rem;
    }
    
    .dialog-controls button {
        font-size: 1.21875rem;
        font-weight: 700;
        line-height: 1;
        text-shadow: 0 1px 0 #fff;
        opacity: .5;
        padding: 0;
        background-color: transparent;
        border: 0;
        cursor: pointer;
        margin-left: 0.25rem;
        margin-right: 0.25rem;
    }

    .dialog-header.dialog-header-fancy {
        background: linear-gradient(250deg, #3e93d6, var(--wp-admin-theme-color));
        color: #fff;
    }

    .dialog-header.dialog-header-fancy .dialog-controls button {
        background: linear-gradient(250deg, #3e93d6, var(--wp-admin-theme-color));
        color: #fff;
    }

    slot[name="buttons"]::slotted(.btn),
    slot[name="buttons"]::slotted(.buttons),
    slot[name="controls"]::slotted(.btn),
    slot[name="controls"]::slotted(.buttons),
    slot[name="title"]::slotted(.btn),
    slot[name="title"]::slotted(.buttons) {
        margin-top: calc(var(--header-padding-y) / 2 * -1) !important;
        margin-bottom: calc(var(--header-padding-y) / 2 * -1) !important;
    }
    
    :host([stickyheader]) .dialog-header {
        position: sticky;
        top: var(--header-sticky-offset, 0);
        z-index: 501;
    }
    
    @media (max-width: 768px) {
        :host {
            --margin-top: 3.5rem;
        }
        .modal-dialog {
            margin: var(--margin-top) 0.5rem 1.75rem 0.5rem;
        }
    }

    @media (min-width: 768px) {
        .modal-dialog {
            margin: var(--margin-top) auto 1.75rem auto;
        }

        .modal-sm {
            max-width: 600px;
        }
        
        .modal-max {
            max-width: calc(100% - 2rem) !important;
        }
    }
    
    @media (min-width: 992px) {
        .modal-sm {
            max-width: 400px;
        }
        .modal-md {
            max-width: 600px;
        }
        .modal-lg,
        .modal-xl {
            max-width: 900px;
        }
    }

    @media (min-width: 1024px) {
        .modal-lg,
        .modal-xl {
            max-width: 1000px;
        }
    }

    @media (min-width: 1300px) {
        .modal-dialog {
            margin: var(--margin-top) auto 1.75rem auto;
        }
        .modal-xl {
            max-width: 1140px;
        }
    }
`;
