import {css, html, LitElement} from '../libs/lit.dist.js?ver=2.5.1';
import './pk-spinner.js?ver=2.5.1';

export class PkGrid extends LitElement {
    static styles = css`
        :host {
            --pk-cols: 12;

            display: grid;
            width: 100%;
            grid-template-columns: repeat(var(--cols, var(--pk-cols)), 1fr);
            column-gap: var(--gap-x, 1.5rem);
            row-gap: var(--gap-y, 0);
        }
    `;
    render() {
        return html`<slot></slot>`
    }
}

window.customElements.define('pk-grid', PkGrid);

export class PkCol extends LitElement {
    static styles = css`
        :host {
            grid-column: auto / span var(--size, 1);
        }

        @media (min-width: 1200px) {
            :host {
                --size: var(--size-xl, var(--size-lg, var(--size-md, var(--size-sm, 1)))) !important;
            }
        }

        @media (max-width: 1200px) {
            :host {
                --size: var(--size-lg, var(--size-md, var(--size-sm, 1))) !important;
            }
        }

        @media (max-width: 768px) {
            :host {
                --size: var(--size-md, var(--size-sm, 1)) !important;
            }
        }

        @media (max-width: 576px) {
            :host {
                --size: var(--size-sm, var(--cols, var(--pk-cols))) !important;
            }
        }
    `;
    render() {
        return html`<slot></slot>`
    }
}

window.customElements.define('pk-col', PkCol);
