import {createToast, TOAST_TYPE_DANGER} from "../custom-elements/pk-toast-message.js?ver=2.5.1";

/**
 * Konwertuje błędy zapytań AJAX na stringi do wyświetlenia
 * @param response
 * @returns {string}
 */
export const convertAjaxResponseErrorMessageToString = response => {
    if (response && typeof response === 'string') {
        return response;
    }

    if (response && response.responseJSON && typeof response.responseJSON.errors === 'object' && !Array.isArray(response.responseJSON.errors)) {
        const errors = Object.values(response.responseJSON.errors).reduce((acc, err) => [...acc, ...err]);
        return errors.join('\n');
    }

    if (response && response.responseJSON && Array.isArray(response.responseJSON.errors)) {
        return response.responseJSON.errors.join('\n');
    }

    if (response && response.responseJSON && response.responseJSON.error) {
        return String(response.responseJSON.error);
    }

    if (response instanceof Error && response.message) {
        return response.message;
    }

    return 'Wystąpił błąd';
};

/**
 * Konwertuje błędy zapytań AJAX na błędy walidacji z serwera
 * @param response
 * @returns {object}
 */
export const convertAjaxResponseErrorToValidationErrors = response => {
    if (response && response.responseJSON && typeof response.responseJSON.errors === 'object' && !Array.isArray(response.responseJSON.errors)) {
        return response.responseJSON.errors;
    }
    return {};
};

/**
 * @param {any} error
 * @param {Partial<ToastMessage> & {
 *     log?: boolean,
 *     useToasts?: boolean,
 * }} options
 * @return {string|string[]|Object}
 */
export const showErrorPopup = (error, options = {}) => {
    const errors = convertAjaxResponseErrorMessageToString(error).split('\n');
    createToast(errors.join('<br>'), {
        type: TOAST_TYPE_DANGER,
        ...options,
    });
    console.error(error);
    return errors;
};
