<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://polkurier.pl
 * @since             1.0.0
 * @package           Polkurier
 *
 * @wordpress-plugin
 * Plugin Name:       Polkurier
 * Plugin URI:        https://www.polkurier.pl/baza-wiedzy/artykul/integracja-z-woocommerce
 * Description:       Rozszerzenie WooCommerce do integracji z platformą Polkurier
 * Version:           2.5.1
 * Author:            Polkurier
 * Author URI:        https://polkurier.pl/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       polkurier
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

if (PHP_VERSION_ID < 70400) {
    add_action('admin_notices', function () {
        echo '<div class="error"><p><strong>Polkurier</strong> wymaga do działania PHP w wersji minimum 7.4</p></div>';
    });
    return;
}

if (isset($wp_version) && version_compare($wp_version, '6.3', '<')) {
    add_action('admin_notices', function () {
        echo '<div class="error"><p><strong>Polkurier</strong> wymaga do działania Wordpress w wersji minimum 6.3</p></div>';
    });
    return;
}

register_activation_hook(__FILE__, static function () {
    $currentDirName = basename(__DIR__);
    foreach (new DirectoryIterator(plugin_dir_path(__FILE__) . '../') as $file) {
        if ($file->isDir() && $file->getFilename() !== $currentDirName && file_exists($file->getRealPath() . '/polkurier.php')) {
            wp_die('<strong>Polkurier:</strong> wtyczka jest już zainstalowana w starszej wersji. Należy najpierw usunąć starszą wersję.');
        }
    }
});

if (defined('POLKURIER_PLUGIN_VERSION')) {
    add_action('admin_notices', function () {
        echo '<div class="error"><p><strong>Polkurier:</strong> wtyczka jest już zainstalowana w starszej wersji. Należy najpierw usunąć starszą wersję.</p></div>';
    });
    return;
}

// Autoload
spl_autoload_register(static function ($className) {
    if (strpos($className, 'Polkurier\\') === 0) {
        $classesDir = realpath(plugin_dir_path(__FILE__)) . DIRECTORY_SEPARATOR . 'src' . DIRECTORY_SEPARATOR;
        $classFile = str_replace(['_', '\\'], DIRECTORY_SEPARATOR, $className) . '.php';
        include_once $classesDir . $classFile;
    }
});

define('POLKURIER_PLUGIN_VERSION', '2.5.1');
define('POLKURIER_PLUGIN_SLUG', plugin_basename(__FILE__));
define('POLKURIER_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('POLKURIER_PLUGIN_URL', plugin_dir_url(__FILE__));

register_activation_hook(__FILE__, static function () {
    (new Polkurier\Activator())->activate();
});

register_deactivation_hook(__FILE__, static function () {
    (new Polkurier\Deactivator())->deactivate();
});

add_action('admin_notices', function () {
    if ((int)get_option('pk-update-notice-1.10.0') === 1) {
        if ($_GET['page'] === 'wc-settings' && $_GET['tab'] === 'shipping') {
            delete_option('pk-update-notice-1.10.0');
            return;
        }
        echo '
            <div class="notice notice-warning inline is-dismissible" data-dismissible="polkurier-update-1100-notice">
                <h3>Polkurier</h3>
                <p>
                    <strong>Uwaga!</strong> od wersji <strong>1.10.0</strong> zmienił się sposób konfiguracji metod wysyłki.<br>
                    Przejdź do zakładki <a href="admin.php?page=wc-settings&tab=shipping">"WooCommerce" &rarr; "Ustawienia" &rarr; "Wysyłka"</a> i zweryfikuj czy ustawienia zostały zaimportowane poprawnie.
                    <br>
                    <br>
                    Więcej informacji znajdziesz w zakładce "Integracje" oraz bazie wiedzy na stronie <a href="https://polkurier.pl">Polkurier.pl</a>
                </p>
            </div>
        ';
    }
});

Polkurier\Polkurier::instance()->run();
