<?php

namespace Polkurier\AddressBook;

use Polkurier\AbstractSimpleObjectManager;
use Polkurier\Normalizer\Denormalizer;
use Polkurier\Normalizer\Normalizer;
use ReflectionException;

/**
 * @extends AbstractSimpleObjectManager<Address>
 */
class AddressBookManager extends AbstractSimpleObjectManager
{

    /**
     * @return Address[]
     */
    public function getSenderAddresses(): array
    {
        return array_filter($this->getAll(), static function (Address $item) {
            return !$item->cover_address;
        });
    }

    /**
     * @return Address[]
     */
    public function getCoverAddresses(): array
    {
        return array_filter($this->getAll(), static function (Address $item) {
            return $item->cover_address;
        });
    }

    public function setDefault(Address $address): self
    {
        foreach ($this->getAll() as $a) {
            if ($address->cover_address === $a->cover_address) {
                $a->default = $a === $address;
            }
        }
        return $this;
    }

    /**
     * @throws ReflectionException
     */
    public function fromArray($data): object
    {
        return (new Denormalizer())->denormalize(new Address(), $data);
    }

    /**
     * @throws ReflectionException
     */
    protected function normalizeItems(array $items): array
    {
        return (new Normalizer())->normalize($items);
    }

    protected function getWPOptionName(): string
    {
        return 'polkurier_address_book';
    }

}
