<?php

namespace Polkurier\BankAccounts;

use Polkurier\AbstractSimpleObjectManager;
use Polkurier\Normalizer\Denormalizer;
use Polkurier\Normalizer\Normalizer;
use ReflectionException;

/**
 * @extends AbstractSimpleObjectManager<BankAccount>
 */
class BankAccountsManager extends AbstractSimpleObjectManager
{

    public function setDefault(BankAccount $bankAccount): self
    {
        foreach ($this->getAll() as $b) {
            $b->default = $b === $bankAccount;
        }
        return $this;
    }

    /**
     * @throws ReflectionException
     */
    public function fromArray($data): object
    {
        return (new Denormalizer())->denormalize(new BankAccount(), $data);
    }

    /**
     * @throws ReflectionException
     */
    protected function normalizeItems(array $items): array
    {
        return (new Normalizer())->normalize($items);
    }

    protected function getWPOptionName(): string
    {
        return 'polkurier_bank_accounts';
    }

}
