<?php

namespace Polkurier\Controller;


use Polkurier\AddressBook\AddressBookManager;
use Polkurier\Http\JsonResponse;
use Polkurier\Http\Request;
use Polkurier\Normalizer\Normalizer;
use ReflectionException;

class AddressesController
{

    /**
     * @throws ReflectionException
     */
    public function indexAction(Request $request): JsonResponse
    {
        return new JsonResponse(
            (new Normalizer())->normalize(
                (new AddressBookManager())->getAll()
            )
        );
    }

}
