<?php

namespace Polkurier\Controller;


use Polkurier\ApiClient;
use Polkurier\Exception\ApiException;
use Polkurier\Exception\HttpException;
use Polkurier\Exception\MethodNotAllowedException;
use Polkurier\Http\JsonResponse;
use Polkurier\Http\Request;
use Polkurier\Util\Arr;

class CourierPointController
{

    /**
     * @throws ApiException
     */
    public function searchAction(Request $request): JsonResponse
    {
        $functions = [];

        if ($request->query->getBoolean('cod')) {
            $functions[] = 'cod';
        }

        if ($request->query->getBoolean('collect')) {
            $functions[] = 'collect';
        }

        if ($request->query->getBoolean('send')) {
            $functions[] = 'send';
        }

        $data = (new ApiClient())->makeApiRequest('get_courier_point', [
            'couriers' => $request->query->getArray('providers'),
            'searchquery' => $request->query->getString('searchQuery'),
            'functions' => $functions
        ]);

        $limit = (int)Arr::get($data, 'limit', 0);
        if ($limit > 0) {
            $data = array_slice($data, 0, $limit);
        }
        return new JsonResponse($data);
    }

    /**
     * @throws HttpException
     */
    public function setCourierPoint(Request $request): JsonResponse
    {
        if (!$request->isPost()) {
            throw new MethodNotAllowedException();
        }

        $courier = $request->request->getString('courier');
        update_option("polkurier_default_point_id_$courier", $request->request->getString('pointId'));
        update_option("polkurier_default_point_label_$courier", $request->request->getString('pointLabel'));
        return new JsonResponse(['success' => true]);
    }

}
