<?php

namespace Polkurier\Controller;


use Polkurier\Http\JsonResponse;
use Polkurier\Http\Request;
use Polkurier\ShipmentTemplate\ShipmentTemplate;
use Polkurier\ShipmentTemplate\ShipmentTemplateManager;
use Polkurier\Types\PackType;

class TemplateController
{

    public function indexAction(Request $request): JsonResponse
    {
        $data = [];
        if (!empty($request->request->getString('id'))) {
            $templates = [(new ShipmentTemplateManager())->getById($request->request->getString('id'))];
        } else {
            $templates = (new ShipmentTemplateManager())->getAll();
        }

        foreach ($templates as $template) {
            if ($template instanceof ShipmentTemplate) {
                $templateData = $template->jsonSerialize();
                $templateData['type_description'] = PackType::getDisplayName($template->type, $template->shipment_type);
                $data[] = $templateData;
            }
        }

        usort($data, static function ($a, $b) {
            return strcmp(strtolower($a['name']), strtolower($b['name']));
        });
        return new JsonResponse($data);
    }

}
