<?php


namespace Polkurier\Http;


use Exception;
use Polkurier\Exception\HttpException;

class ErrorJsonResponse extends JsonResponse
{

    public static function createFromException(Exception $exception): self
    {
        $code = 500;
        if ($exception instanceof HttpException) {
            $code = $exception->getCode();
        }
        return new self([
            'error' => $exception->getMessage(),
            'code' => $code,
        ], $code);
    }

}
