<?php


namespace Polkurier\Http;

use Polkurier\Util\File;

class FileResponse extends Response
{

    public function __construct(?File $file, bool $inline = true, int $code = 200, array $headers = [])
    {
        if ($file !== null) {
            $headers['Content-Type'] = $file->contentType;
            $headers['Content-Disposition'] = ($inline ? 'inline' : 'download') . '; filename="' . $file->name . '"';
            if ($inline) {
                $headers['Cache-Control'] = 'public, must-revalidate, max-age=0';
                $headers['Pragma'] = 'public';
                $headers['Expires'] = 'Sat, 26 Jul 1997 05:00:00 GMT';
                $headers['Last-Modified'] = gmdate('D, d M Y H:i:s') . ' GMT';
            }
        }
        parent::__construct($file !== null ? $file->content : '', $code, $headers);
    }

    public function send(): Response
    {
        ob_clean();
        return parent::send();
    }

}
