<?php

namespace Polkurier\Integrations;

use WC_Shipping_Method;

abstract class AbstractIntegration
{

    public function getSelectButtonLabel(WC_Shipping_Method $method): string
    {
        return __('Wybierz punkt', 'polkurier');
    }

    /**
     * @param string $key
     * @return mixed|string
     */
    protected function getPostData(string $key)
    {
        if (isset($_POST['post_data'])) {
            $data = [];
            parse_str($_POST['post_data'], $data);
            if (isset($data[$key])) {
                return $data[$key];
            }
        }
        return '';
    }

    abstract public function getMapProviders(WC_Shipping_Method $method): array;

}
