<?php

namespace Polkurier\Order;

use DateTimeImmutable;

class Order
{

    private ?int $id = null;
    private string $order_number = '';
    private array $label = [];
    private float $price_gross = 0.0;
    private float $price_net = 0.0;
    private ?int $shop_order_id = null;
    private string $courier = '';
    private string $shipment_type = '';
    private string $description = '';
    private ?OrderAddress $sender = null;
    private ?OrderAddress $recipient = null;
    private ?OrderAddress $cover_address = null;

    /**
     * @var OrderPack[]
     */
    private array $packs = [];

    private ?OrderPickup $pickup = null;
    private ?OrderCod $cod = null;
    private float $insurance = 0.0;
    private ?DateTimeImmutable $date_created = null;
    private ?DateTimeImmutable $delivered_date = null;
    private string $status_code = '';
    private array $extra = [];

    /** @var array<string, bool> */
    private array $courier_services = [];
    private ?int $author_id = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(int $id): Order
    {
        $this->id = $id;
        return $this;
    }

    public function setShopOrderId(int $shop_order_id): Order
    {
        $this->shop_order_id = $shop_order_id;
        return $this;
    }

    public function setCourier(string $courier): Order
    {
        $this->courier = $courier;
        return $this;
    }

    public function setShipmentType(string $shipment_type): Order
    {
        $this->shipment_type = $shipment_type;
        return $this;
    }

    public function setDescription(string $description): Order
    {
        $this->description = $description;
        return $this;
    }

    public function setSender(?OrderAddress $sender): Order
    {
        $this->sender = $sender;
        return $this;
    }

    public function setRecipient(?OrderAddress $recipient): Order
    {
        $this->recipient = $recipient;
        return $this;
    }

    public function setCoverAddress(?OrderAddress $cover_address): Order
    {
        $this->cover_address = $cover_address;
        return $this;
    }

    /**
     * @param OrderPack[] $packs
     */
    public function setPacks(array $packs): Order
    {
        $this->packs = $packs;
        return $this;
    }

    public function setPickup(?OrderPickup $pickup): Order
    {
        $this->pickup = $pickup;
        return $this;
    }

    public function setInsurance(float $insurance): Order
    {
        $this->insurance = $insurance;
        return $this;
    }

    public function setCourierService(string $service, bool $set = true): Order
    {
        $this->courier_services[$service] = $set;
        return $this;
    }

    public function setCod(?OrderCod $cod): Order
    {
        $this->cod = $cod;
        return $this;
    }

    public function getShopOrderId(): string
    {
        return $this->shop_order_id;
    }

    public function getCourier(): string
    {
        return $this->courier;
    }

    public function getShipmentType(): string
    {
        return $this->shipment_type;
    }

    public function getDescription(): string
    {
        return $this->description;
    }

    public function getSender(): ?OrderAddress
    {
        return $this->sender;
    }

    public function getRecipient(): ?OrderAddress
    {
        return $this->recipient;
    }

    public function getCoverAddress(): ?OrderAddress
    {
        return $this->cover_address;
    }

    /**
     * @return OrderPack[]
     */
    public function getPacks(): array
    {
        return $this->packs;
    }

    public function getPickup(): ?OrderPickup
    {
        return $this->pickup;
    }

    public function getCod(): ?OrderCod
    {
        return $this->cod;
    }

    public function getInsurance(): float
    {
        return $this->insurance;
    }

    /**
     * @return array<string, bool>
     */
    public function getCourierServices(): array
    {
        return $this->courier_services;
    }

    public function getOrderNumber(): string
    {
        return $this->order_number;
    }

    public function setOrderNumber(string $order_number): Order
    {
        $this->order_number = $order_number;
        return $this;
    }

    /**
     * @return string[]
     */
    public function getLabel(): array
    {
        return $this->label;
    }

    public function setLabel(array $label): Order
    {
        $this->label = $label;
        return $this;
    }

    public function getPriceGross(): float
    {
        return $this->price_gross;
    }

    public function setPriceGross(float $price_gross): Order
    {
        $this->price_gross = $price_gross;
        return $this;
    }

    public function getPriceNet(): float
    {
        return $this->price_net;
    }

    public function setPriceNet(float $price_net): Order
    {
        $this->price_net = $price_net;
        return $this;
    }

    public function getDateCreated(): ?DateTimeImmutable
    {
        return $this->date_created;
    }

    public function setDateCreated(?DateTimeImmutable $date_created = null): Order
    {
        $this->date_created = $date_created;
        return $this;
    }

    public function getStatusCode(): string
    {
        return $this->status_code;
    }

    public function setStatusCode(string $status_code): Order
    {
        $this->status_code = $status_code;
        return $this;
    }

    public function getDeliveredDate(): ?DateTimeImmutable
    {
        return $this->delivered_date;
    }

    public function setDeliveredDate(?DateTimeImmutable $delivered_date): Order
    {
        $this->delivered_date = $delivered_date;
        return $this;
    }

    public function getExtra(): array
    {
        return $this->extra;
    }

    public function setExtra(array $extra): Order
    {
        $this->extra = $extra;
        return $this;
    }

    public function getExtraValue(string $key, $default = null)
    {
        return $this->extra[$key] ?? null;
    }

    public function setExtraValue(string $key, $value): Order
    {
        $this->extra[$key] = $value;
        return $this;
    }

    public function getAuthorId(): ?int
    {
        return $this->author_id;
    }

    public function setAuthorId(?int $author_id): Order
    {
        $this->author_id = $author_id;
        return $this;
    }

}
