<?php

namespace Polkurier\Order;

use Polkurier\ApiClient;
use Polkurier\Exception\ApiException;
use Polkurier\Util\File;

class OrderDocuments
{

    /**
     * @param string[] $ordersNumbers
     * @return File
     * @throws ApiException
     */
    public function getLabel(array $ordersNumbers): File
    {
        return $this->getDocument('label', $ordersNumbers);
    }

    /**
     * @param string[] $ordersNumbers
     * @return File
     * @throws ApiException
     */
    public function getProtocol(array $ordersNumbers): File
    {
        return $this->getDocument('protocol', $ordersNumbers);
    }

    /**
     * @param string $type
     * @param string[] $ordersNumbers
     * @return File
     * @throws ApiException
     */
    public function getDocument(string $type, array $ordersNumbers): File
    {
        switch ($type) {
            case 'label':
                $apiMethod = 'get_label';
                $documentName = 'label';
                break;

            case 'protocol':
                $apiMethod = 'get_protocol';
                $documentName = 'protocol';
                break;

            default:
                throw new ApiException("Błędny typ dokumentu: $type");
        }

        $data = (array)(new ApiClient())->makeApiRequest($apiMethod, [
            'orderno' => $ordersNumbers,
        ]);

        if (empty($data["file"])) {
            throw new ApiException('Brak dokumentu');
        }

        if (count($ordersNumbers) > 1) {
            $name = $documentName . '_' . time() . '.pdf';
        } else {
            $name = $documentName . '_' . $ordersNumbers[0] . '.pdf';
        }
        return new File($name, base64_decode($data["file"]), 'application/pdf');
    }

}
