<?php

namespace Polkurier;

use DateTime;

class PluginInfo
{

    public string $version = '';
    public string $tested = '';
    public ?DateTime $date = null;
    public string $package_url = '';
    public string $readme_url = '';
    public string $icon_url = '';
    public string $changelog = '';

    /**
     * @var array<string, string>
     */
    public array $require = [];

    public function getDependencyVersion(string $name): string
    {
        return $this->require[$name] ?? '';
    }

    public function isUpdateAvailable(): bool
    {
        return version_compare(Polkurier::VERSION, $this->version, '<');
    }

    public function isUpdateCompatible(): bool
    {
        global $wp_version;

        if (!empty($this->require)) {
            foreach ($this->require as $dependency => $version) {
                if ($version === '*') {
                    continue;
                }

                if (strpos($version, ' ') !== false) {
                    $version = explode(' ', trim($version))[0];
                }

                $installedVersion = '';
                switch ($dependency) {
                    case 'php':
                        $installedVersion = PHP_VERSION;
                        break;

                    case 'wordpress':
                        $installedVersion = $wp_version;
                        break;

                    case 'woocommerce':
                        if (function_exists('WC')) {
                            $installedVersion = WC()->version;
                        }
                        break;
                }

                if (!version_compare($installedVersion, trim($version), '>=')) {
                    return false;
                }
            }
        }
        return true;
    }

}
