<?php

namespace Polkurier\ShippingMethods;

class InpostParcelMachineShippingMethodMethod extends AbstractShippingMethod
{

    protected function getDefaultTitle(): string
    {
        return 'Paczkomaty InPost';
    }

    public function getId(): string
    {
        return 'pk_inpost_paczkomat';
    }

    public function getPolkurierId(): string
    {
        return 'INPOST_PACZKOMAT';
    }

    public function isParcelPickupPoint(): bool
    {
        return true;
    }

    public function getSelectButtonLabel(): string
    {
        return __('Wybierz paczkomat', 'polkurier');
    }

    public function getSelectedPointLabel(): string
    {
        return __('Wybrany paczkomat', 'polkurier');
    }

    protected function getErrorMessages(): array
    {
        return [
            self::ERROR_MESSAGE_NOT_POINT_SELECTED => __('Nie wybrano paczkomatu', 'polkurier'),
            self::ERROR_MESSAGE_NO_PHONE_NUMBER => __('Numer telefonu jest wymagany', 'polkurier'),
        ];
    }

}
