<?php
declare(strict_types=1);

namespace Polkurier\Types;

final class OrderStatusType
{

    public const WAITING = 'O';
    public const CONFIRMED = 'P';
    public const WAITING_FOR_PICKUP = 'OC';
    public const CANCELLED = 'A';
    public const IN_TRANSIT = 'WP';
    public const DELIVERED = 'D';
    public const RETURN = 'Z';
    public const EXCEPTION = 'W';
    public const MULTI_PICKUP = 'PZ';

    public static function getDisplayName(string $code): string
    {
        switch ($code) {
            case self::WAITING:
            case self::WAITING_FOR_PICKUP:
                return 'Oczekuje';

            case self::CONFIRMED:
                return 'Potwierdzone';

            case self::CANCELLED:
                return 'Anulowane';

            case self::IN_TRANSIT:
                return 'W przewozie';

            case self::DELIVERED:
                return 'Dostarczone';

            case self::RETURN:
                return 'Zwrot do nadawcy';

            case self::EXCEPTION:
                return 'Wyjątek';

            case self::MULTI_PICKUP:
                return 'Podjazd zbiorczy';
        }
        return '';
    }

}
