<?php

namespace Polkurier\Types;

final class PackType
{

    public const ST = 'ST';
    public const NST = 'NST';
    public const PPAL = 'PPAL'; // 80x60
    public const PAL = 'PAL'; // 120x100
    public const DLU = 'DLU';
    public const VP = 'VP'; // 60x40,
    public const EUR2 = 'EUR2'; // 120X100,
    public const PA15 = 'PA15'; // 150X150,

    public static function getDisplayName(string $type, string $shipment_type = ShipmentType::BOX): string
    {
        switch ($shipment_type) {
            case ShipmentType::PALETTE:
                switch ($type) {
                    case self::NST:
                        return 'Paleta EURO 120×80 (niestandardowa)';
                    case self::PPAL:
                        return 'Półpaleta 80×60';
                    case self::PAL:
                        return 'Paleta 120×100';
                    case self::VP:
                        return 'Ćwierćpaleta 60×40';
                    case self::EUR2:
                        return 'Paleta 120×120';
                    case self::PA15:
                        return 'Paleta 150×150';
                }
                return 'Paleta EURO 120×80';

            case ShipmentType::BOX:
                switch ($type) {
                    case self::NST:
                        return 'Paczka niestandardowa';

                    case self::DLU:
                        return 'Dłużyca';
                }
                return 'Paczka standardowa';
        }
        return ShipmentType::getDisplayName($shipment_type);
    }

}
