<?php

namespace Polkurier\Upgrade\Migrations;

use Polkurier\Logger;
use Polkurier\Upgrade\DatabaseMigrationInterface;

class MigrateFrom11To12 implements DatabaseMigrationInterface
{

    public function fromVersion(): int
    {
        return 11;
    }

    public function toVersion(): int
    {
        return 12;
    }

    private function queryDb(string  $query): void
    {
        global $wpdb;
        $wpdb->query($query);
        if ($wpdb->last_error !== '') {
            (new Logger())->error("Polkurier BD Upgrade: {$wpdb->last_error}");
        }
    }

    public function doUpgrade(): void
    {
        global $wpdb;

        $this->queryDb("ALTER TABLE {$wpdb->prefix}polkurier_orders ADD courier_services TEXT NULL;");
        $this->queryDb("ALTER TABLE {$wpdb->prefix}polkurier_orders ADD packs TEXT NULL;");

        $this->queryDb("ALTER TABLE {$wpdb->prefix}polkurier_orders MODIFY COLUMN packs text NULL;");
        $this->queryDb("ALTER TABLE {$wpdb->prefix}polkurier_orders MODIFY COLUMN courier_services text NULL;");

        $this->queryDb("UPDATE {$wpdb->prefix}polkurier_orders SET packs = NULL WHERE packs = ''");
        $this->queryDb("UPDATE {$wpdb->prefix}polkurier_orders SET courier_services = NULL WHERE courier_services = ''");
    }

}
