<?php

namespace Polkurier\Upgrade\Migrations;

use Polkurier\Upgrade\DatabaseMigrationInterface;

class MigrateFrom1To2 implements DatabaseMigrationInterface
{

    public function fromVersion(): int
    {
        return 1;
    }

    public function toVersion(): int
    {
        return 2;
    }

    public function doUpgrade(): void
    {
        $settings = get_option('woocommerce_pk_paczka_w_ruchu_settings');
        if (!empty($settings) && isset($settings['method_title']) && $settings['method_title'] === 'Paczka w RUCHu') {
            $settings['method_title'] = 'ORLEN Paczka';
            update_option('woocommerce_pk_paczka_w_ruchu_settings', $settings);
        }
    }

}
