<?php

namespace Polkurier\Upgrade\Migrations;

use Polkurier\ShippingMethods\InpostParcelMachineShippingMethodMethod;
use Polkurier\ShippingMethods\PaczkaWRuchuShippingMethodMethod;
use Polkurier\Upgrade\DatabaseMigrationInterface;

class MigrateFrom3To4 implements DatabaseMigrationInterface
{

    public function fromVersion(): int
    {
        return 3;
    }

    public function toVersion(): int
    {
        return 4;
    }

    public function doUpgrade(): void
    {
        global $wpdb;
        $shippings = [
            new InpostParcelMachineShippingMethodMethod(0),
            new PaczkaWRuchuShippingMethodMethod(0),
        ];
        $zones = (array)\WC_Shipping_Zones::get_zones();
        $zones[] = ['id' => 0];
        foreach ($shippings as $shipping) {
            if ($shipping->is_enabled() && (float)$shipping->get_option('fee') > 0.0) {
                foreach ($zones as $zone) {
                    $position = (int)$wpdb->get_var("SELECT MAX(method_order) FROM {$wpdb->prefix}woocommerce_shipping_zone_methods WHERE zone_id = {$zone['id']};");
                    $wpdb->insert($wpdb->prefix . 'woocommerce_shipping_zone_methods', [
                        'zone_id' => $zone['id'],
                        'method_id' => $shipping->getId(),
                        'method_order' => $position + 1,
                        'is_enabled' => 1,
                    ]);
                    $shippingMethod = new InpostParcelMachineShippingMethodMethod($wpdb->insert_id);
                    update_option($shippingMethod->get_instance_option_key(), [
                        "enabled" => "yes",
                        "title" => $shipping->get_option('method_title'),
                        "cost" => $shipping->get_option('fee'),
                        "cost_cod" => $shipping->get_option('fee_cod'),
                        "free_shipping_from" => $shipping->get_option('free_shipping_from'),
                    ]);
                }
                update_option('pk-update-notice-1.10.0', 1);
            }
        }
    }

}
