<?php

namespace Polkurier\Upgrade\Migrations;

use Polkurier\Upgrade\DatabaseMigrationInterface;

class MigrateFrom5To6 implements DatabaseMigrationInterface
{

    public function fromVersion(): int
    {
        return 5;
    }

    public function toVersion(): int
    {
        return 6;
    }

    public function doUpgrade(): void
    {
        global $wpdb;
        dbDelta("
            CREATE TABLE `{$wpdb->prefix}polkurier_shipping_points` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `wp_order_id` int(11) NOT NULL,
              `code` varchar(100) NOT NULL DEFAULT '',
              `label` varchar(1000) NOT NULL DEFAULT '',
              `provider` varchar(100) NOT NULL DEFAULT '',
              `type` varchar(100) DEFAULT '',
              PRIMARY KEY (`id`),
              KEY `wp_polkurier_shipping_points_wp_order_id_IDX` (`wp_order_id`) USING BTREE,
              KEY `wp_polkurier_shipping_points_code_IDX` (`code`) USING BTREE
            ) ENGINE=InnoDB {$wpdb->get_charset_collate()};
        ");
    }

}
