<?php

namespace Polkurier\Upgrade\Migrations;

use Polkurier\Upgrade\DatabaseMigrationInterface;

class MigrateFrom6To7 implements DatabaseMigrationInterface
{

    public function fromVersion(): int
    {
        return 6;
    }

    public function toVersion(): int
    {
        return 7;
    }

    public function doUpgrade(): void
    {
        global $wpdb;
        if (!function_exists('wc_get_order')) {
            return;
        }
        $data = $wpdb->get_results("SELECT * FROM `{$wpdb->prefix}polkurier_shipping_points`");
        if (is_array($data)) {
            foreach ($data as $row) {
                $order = wc_get_order($row->wp_order_id);
                if ($order) {
                    $order->update_meta_data('_polkurier_point_id', $row->code);
                    $order->update_meta_data('_polkurier_provider', $row->provider);
                    $order->update_meta_data('_polkurier_point_label', $row->label);
                    $order->update_meta_data('_polkurier_point_type', $row->type);
                    $order->save_meta_data();
                }
            }
        }
    }

}
