<?php

namespace Polkurier\Upgrade\Migrations;

use Polkurier\AddressBook\Address;
use Polkurier\AddressBook\AddressBookManager;
use Polkurier\BankAccounts\BankAccount;
use Polkurier\BankAccounts\BankAccountsManager;
use Polkurier\Upgrade\DatabaseMigrationInterface;

class MigrateFrom9To10 implements DatabaseMigrationInterface
{

    public function fromVersion(): int
    {
        return 9;
    }

    public function toVersion(): int
    {
        return 10;
    }

    public function doUpgrade(): void
    {
        $this->upgradeDatabase();
        $this->convertBankAccounts();
        $this->convertAddresses();
    }

    public function upgradeDatabase(): void
    {
        global $wpdb;
        $wpdb->query("ALTER TABLE {$wpdb->prefix}polkurier_orders CHANGE wp_order_id shop_order_id int DEFAULT NULL NULL;");
        $wpdb->query("ALTER TABLE {$wpdb->prefix}polkurier_orders CHANGE carrier courier varchar(255) DEFAULT '' NOT NULL;");
        $wpdb->query("ALTER TABLE {$wpdb->prefix}polkurier_orders CHANGE address sender text DEFAULT NULL NULL;");
        $wpdb->query("ALTER TABLE {$wpdb->prefix}polkurier_orders CHANGE address_to recipient text DEFAULT NULL NULL;");
        $wpdb->query("ALTER TABLE {$wpdb->prefix}polkurier_orders ADD cover_address TEXT DEFAULT null NULL;");
        $wpdb->query("ALTER TABLE {$wpdb->prefix}polkurier_orders ADD cod TEXT DEFAULT null NULL;");
        $wpdb->query("ALTER TABLE {$wpdb->prefix}polkurier_orders ADD pickup TEXT DEFAULT null NULL;");
        $wpdb->query("ALTER TABLE {$wpdb->prefix}polkurier_orders ADD insurance DECIMAL(10,2) DEFAULT 0.0 NOT NULL;");
        $wpdb->query("ALTER TABLE {$wpdb->prefix}polkurier_orders ADD courier_services TEXT NULL;");
        $wpdb->query("ALTER TABLE {$wpdb->prefix}polkurier_orders ADD shipment_type varchar(50) DEFAULT '' NOT NULL;");
        $wpdb->query("ALTER TABLE {$wpdb->prefix}polkurier_orders ADD description varchar(100) DEFAULT '' NOT NULL;");
        $wpdb->query("ALTER TABLE {$wpdb->prefix}polkurier_orders ADD packs TEXT NULL;");

    }

    private function convertBankAccounts(): void
    {
        $bankAccountsManager = new BankAccountsManager();
        foreach ((array)get_option('polkurier_accounts', []) as $row) {
            if (is_object($row)) {
                $row = get_object_vars($row);
            }
            if (!is_array($row)) {
                continue;
            }
            $account = new BankAccount();
            $account->id = $row['id'] ?? null;
            $account->account = (string)($row['account'] ?? null);
            $account->alias = (string)($row['alias'] ?? null);
            $account->default = (bool)($row['default'] ?? false);
            $bankAccountsManager->persist($account);
        }
        $bankAccountsManager->save();
    }

    private function convertAddresses(): void
    {
        $addressBookManager = new AddressBookManager();
        $types = [
            'polkurier_addresses' => [
                'cover_address' => false,
            ],
            'polkurier_cover_addresses' => [
                'cover_address' => true,
            ],
        ];

        foreach ($types as $type => $typeOptions) {
            foreach ((array)get_option($type, []) as $row) {
                if (is_object($row)) {
                    $row = get_object_vars($row);
                }
                if (!is_array($row)) {
                    continue;
                }

                $address = new Address();
                $address->alias = (string)($row['alias'] ?? null);
                $address->default = (bool)($row['default'] ?? null);
                $address->cover_address = $typeOptions['cover_address'];

                $addressData = (array)($row['address'] ?? []);
                $address->company = (string)($addressData['company'] ?? '');
                $address->person = (string)($addressData['person'] ?? '');
                $address->street = (string)($addressData['street'] ?? '');
                $address->housenumber = (string)($addressData['housenumber'] ?? '');
                $address->flatnumber = (string)($addressData['flatnumber'] ?? '');
                $address->postcode = (string)($addressData['postcode'] ?? '');
                $address->city = (string)($addressData['city'] ?? '');
                $address->country = (string)($addressData['country'] ?? '');
                $address->email = (string)($addressData['email'] ?? '');
                $address->phone = (string)($addressData['phone'] ?? '');
                $address->account_id = (string)($addressData['account_id'] ?? '');

                $addressBookManager->persist($address);
            }
        }
        $addressBookManager->save();
    }

}
