<?php

namespace Polkurier\Util;

class ParameterBag
{

    /**
     * @var array<string, mixed>
     */
    private array $data;

    /**
     * @param array<string, mixed> $data
     */
    public function __construct(array $data = [])
    {
        $this->data = $data;
    }

    /**
     * @return array<string, mixed>
     */
    public function all(): array
    {
        return $this->data;
    }

    public function set(string $key, $value): self
    {
        $this->data[$key] = $value;
        return $this;
    }

    /**
     * @param string $key
     * @param mixed $default
     * @return mixed|null
     */
    public function get(string $key, $default = null)
    {
        return $this->data[$key] ?? $default;
    }

    public function has(string $key): bool
    {
        return isset($this->data[$key]);
    }

    public function getString(string $key, string $default = ''): string
    {
        return (string)$this->get($key, $default);
    }

    public function getInt(string $key, int $default = 0): int
    {
        return (int)$this->get($key, $default);
    }

    public function getFloat(string $key, float $default = 0.0): float
    {
        return (float)$this->get($key, $default);
    }

    public function getArray(string $key, array $default = []): array
    {
        return (array)$this->get($key, $default);
    }

    public function getBoolean(string $key, bool $default = false): bool
    {
        return (bool)filter_var($this->get($key, $default), FILTER_VALIDATE_BOOL);
    }

}
