<?php

//
// @deprecated
//

if (!defined('WPINC')) {
    die;
}

/**
 * @var Courier[] $couriers
 * @var Request $request
 * @var CourierMessageManager $couriersMessagesManager
 * @var AddressBookManager $addressBook
 * @var MapsToken $mapToken
 */

use Polkurier\AddressBook\AddressBookManager;
use Polkurier\BankAccounts\BankAccountsManager;
use Polkurier\CourierMessageManager;
use Polkurier\MapsToken;
use Polkurier\Models\Courier;
use Polkurier\Http\Request;
use Polkurier\Order\OrderShippingPointManager;
use Polkurier\Types\PackType;
use Polkurier\Types\ShipmentType;
use Polkurier\Util\Arr;
use Polkurier\Util\Notice;
use Polkurier\Util\OrderTools;

function pk_get_post_param($path) {
    global $_POST;
    return Arr::getByPath($_POST, $path);
}

$isPost = $request->isPost();
$packagesList = null;
if (isset($_POST['packages_list'])) {
    $packagesList = json_decode(stripslashes($_POST['packages_list']), true, JSON_UNESCAPED_SLASHES);
}

if (isset($isOrderDefined) && $isOrderDefined) {
    Notice::error(
        "Uwaga! Dla zamówienia #"
        . (int)$_GET['order_id']
        . " zdefiniowano już zamówienie Polkurier. "
        . "Aby przejrzeć istniejące zamówienia, przejdź do <a href=\"admin.php?page=polkurier_packages\">listy paczek</a>."
    );
}

$orderId = $request->query->getInt('order_id');
$order = wc_get_order($orderId);
$order_data = $order ? $order->get_data() : [];

$selectedCarrier = $request->request->getString('polkurier_carrier_id');
$orderSelectedCarrier = (string)get_post_meta($orderId, '_polkurier_provider', true);

if (empty($orderSelectedCarrier)) {
    $shippingMethod = OrderTools::getShippingMethod($order);
    if ($shippingMethod !== null && OrderTools::isOwnShippingMethod($shippingMethod)) {
        $orderSelectedCarrier = $shippingMethod->getPolkurierId();
    }
}

if (empty($selectedCarrier) && !empty($orderSelectedCarrier)) {
    $selectedCarrier = $orderSelectedCarrier;
}

if (empty($selectedCarrier)) {
    $selectedCarrier = get_option('polkurier_default_carrier_id');
}

// Dane o punkcie odbioru z zamówienia
$orderSelectedPointId = $request->request->getString('recipient_machinename');
$orderSelectedPointLabel = '';
if (empty($orderSelectedPointId)) {
    $shippingPoint = (new OrderShippingPointManager())->get($orderId);
    if ($shippingPoint !== null) {
        $orderSelectedPointId = $shippingPoint->code;
        $orderSelectedPointLabel = $shippingPoint->label;
    }
}

// Jeśli InPost zagraniczny
if ($selectedCarrier === 'INPOST_PACZKOMAT' && $order_data['shipping']['country'] !== 'PL') {
    $selectedCarrier = 'INPOST_INTERNATIONAL';
}

$codAmount = isset($_POST['polkurier_pobranie']) ? $_POST['polkurier_pobranie'] : null;
if ($codAmount === null && $order->get_payment_method() === 'cod') {
    $codAmount = $order->get_total();
}

$insurance = $request->request->getFloat('polkurier_ubezpieczenie');
if ($insurance === 0.0 && (int)get_option('polkurier_default_courierservice_INSURANCE') === 1) {
    $insurance = $order->get_total();
}

?>

<script type="module">
    import '@polkurier/custom-elements/pk-banner.js?ver=2.5.1';
    import {ajaxRequest} from '@polkurier/util/http.js?ver=2.5.1';
    POLKURIER.ajaxRequest = ajaxRequest;
</script>

<pk-banner type="warning" icon="parcel-problem" style="margin: 10px 12px">
    <strong>Polkurier.pl – Ten widok jest przestarzały i zostanie usunięty w wersji 3.0.</strong>
    Zachęcamy do skorzystania z szybkiego nadawania przesyłki z <a href="admin.php?page=wc-orders">listy zamówień</a>
    lub <a href="?page=wc-orders&action=edit&id=<?php echo $_GET['order_id'] ?>">szczegółów zamówienia</a>
    za pomocą przycisku
    <img alt="" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACEAAAAdCAYAAAAkXAW5AAAAAXNSR0IArs4c6QAAAARjSUNQAQ0AAZxpOzIAAAM6SURBVEiJ7ZZZTFNZHIe/W7pQoCAqo6ZKzIQoRM0Q96qRqIm7BpUYRR8kMZNJyGQwxhkclwkmLonR+KYP7hFZbBgTNdoI0VI1oghWRBGBITPaulCWtpQK7b3z1MhmCy3GaPwe7znnd7+c8//fc4XW1jaJL4zsSwvwTUgUmqrIyS3B6e4MSUIIpiZevGpix6nrlNe+AmBEdAS/p81n08JkZILweSUsNjvv29pJ3XeBD12ePuMTtCM5mLEEXVL80Es4Oj5wqMDI+ZIKpiZoyVw1m6tlNRTdrUaU+i5fMXMie9MXMS4uJnQJSYKCUjMH8m/TZHd9XCQIpM2bzNq5kzhlKKe4sq7PWpVCzs/LZpC1Zi5qpcKvhN/CtLvchCsURKlVveQkLpmqyDiqJ/nHMeRlb2BagrZnsExAIQ+jrd3tV4BAO3Go0Ii5wcqOtPlU1ls4dvkutm474mPMcA1/rE8hUqXkSJGJqQlati6dzsVbZspq/sOwP8OvRMAWNVb9w8q/znG/5l/Obk/jt9Q5qBTyHnOszQ6yTlzlTnUjf+/ZzHCNmuV7znLyxkM6PX0LuDdyf4Pdu+3agxdcf1jLal0S+l3p5BufkG804xUlpowfTeaq2dRbm5mVdRy7y90tI3DL+pXoXfiiJHH53jOu3H/OhpSfyMveyLtWJ29aHOw8Y6DF2dFPRuAvgF8JHzJBYFRsFDaHiy6PiFeUyL31mMLSJ8Rq1LxrbR9ITGgSMZHhnN62jhuPatGOiCHvtpnKegtdXjFkAQZzd5Q+beRKWQ0vLU0U/LmRKeNHh/zyQUto1EpGRkegUas4bSgnSq0cMokBHUeLs4OKOgupuknUW210ery8bwv9GHz43Yll0yeQOC4OAP2dp+TklqBSyHn5uok6iy1geHREOFuXzgg4L+AFJkoS54srOawv7bcF+yNMJpC+IJns9SnERqlDl/Bhd7k5rDdxrrgCj1f85DxdUjz7tywmcWzcgIQHJeGjwdrMzjMGTNWNPZ7Hxw1jd/oCVs5MHExccBI+blbUkXOxhLctTn5dreOX5bNQKsKCiQpeAsDjFWl2dPDDsMhgI0KXGCq+/l/+oeK7hI//ASktUPdn7qkqAAAAAElFTkSuQmCC">
    <br>
    Więcej informacji znajdziesz w naszej <a href="https://www.polkurier.pl/baza-wiedzy/artykul/integracja-z-woocommerce">bazie wiedzy.</a>
</pk-banner>

<form method="post" id="pk-order-form">
    <h2>Nowa przesyłka dla zamówienia #<?php echo $order_data['id'] ?></h2>
    <input type="hidden" name="packages_list" id="packages_list"
           data-json="<?php echo is_array($packagesList) ? htmlspecialchars(json_encode($packagesList), ENT_QUOTES, 'UTF-8') : null ?>">
    <table class="form-table">
        <tbody>
        <tr>
            <th scope="row"><label for="polkurier_type">Typ przesyłki</label></th>
            <td>
                <input type="radio" name="polkurier_type" id="polkurier_type_1" value="<?php echo ShipmentType::ENVELOPE ?>">
                <label for="polkurier_type_1">koperta</label><br/>
                <input type="radio" name="polkurier_type" id="polkurier_type_2" value="<?php echo ShipmentType::BOX ?>" checked>
                <label for="polkurier_type_2">paczka</label><br/>
                <input type="radio" name="polkurier_type" id="polkurier_type_3" value="<?php echo ShipmentType::PALETTE ?>">
                <label for="polkurier_type_3">paleta</label>
            </td>
        </tr>
        <tr>
            <th scope="row"><label for="polkurier_template">Użyj szablonu paczki</label></th>
            <td>
                <?php $packages = get_option('polkurier_packages'); ?>
                <select id="polkurier_template_id" name="polkurier_template_id">
                    <option value="">pomiń</option>
                    <?php foreach ($templates as $template): ?>
                        <option
                            value="<?php echo $template->id ?>"
                            class="polkurier-paczka polkurier-paczka-<?php echo $template->type ?>"
                            data-type="<?php echo $template->shipment_type ?>"
                        >
                            <?php echo $template->name ?>
                            (<?php echo PackType::getDisplayName($template->type, $template->shipment_type) ?>,
                            wymiary: <?php echo $template->height . '×' . $template->width . '×' . $template->length . 'cm' ?>,
                            waga: <?php echo $template->weight . 'kg' ?>,
                            ilość: <?php echo $template->amount ?>)
                        </option>
                    <?php endforeach; ?>
                </select>
            </td>
        </tr>
        <tr id="new_package">
            <th scope="row"><label for="polkurier_package">Wymiary paczki</label></th>
            <td>
                <table class="form-table">
                    <tbody>
                    <tr>
                        <th scope="row"><label for="polkurier_height">Wysokość (cm)</label></th>
                        <td><input type="number" name="polkurier_height" id="polkurier_height" value=""></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="polkurier_width">Szerokość (cm)</label></th>
                        <td><input type="number" name="polkurier_width" id="polkurier_width" value=""></td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="polkurier_depth">Głębokość (cm)</label>
                        </th>
                        <td>
                            <input type="number" name="polkurier_depth" id="polkurier_depth" value="">
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="polkurier_weight">Waga (kg)</label></th>
                        <td><input type="number" name="polkurier_weight" id="polkurier_weight" value=""></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="polkurier_count">Ilość</label></th>
                        <td><input type="number" name="polkurier_count" id="polkurier_count" value="1"></td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="polkurier_pack_type">Typ</label>
                        </th>
                        <td>
                            <select name="polkurier_pack_type" id="polkurier_pack_type">
                                <?php foreach (ShipmentType::PACK_TYPES as $shipmentType => $packTypes): ?>
                                    <?php foreach ($packTypes as $packType): ?>
                                        <option
                                            value="<?php echo $packType ?>"
                                            data-type="<?php echo $shipmentType ?>"
                                        >
                                            <?php echo PackType::getDisplayName($packType, $shipmentType) ?>
                                        </option>
                                    <?php endforeach; ?>
                                <?php endforeach; ?>
                            </select>
                        </td>
                    </tr>
                    </tbody>
                </table>
                <button class="button button-primary" onclick="return fn_polkurier_add_package()">Dodaj paczkę do
                    zamówienia
                </button>
                <div id="packages_description"></div>
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="polkurier_carrier">
                    Przewoźnik
                </label>
            </th>
            <td>
                <?php foreach ($couriers as $carrier): ?>
                    <div id="polkurier-courier-<?php echo $carrier->servicecode ?>" data-id="<?php echo $carrier->servicecode ?>" class="polkurier-courier-container">
                        <input
                                id="polkurier_default_id_<?php echo $carrier->servicecode ?>"
                                type="radio"
                                class="polkurier_carrier"
                                name="polkurier_carrier_id"
                                value="<?php echo $carrier->servicecode ?>"
                                required
                            <?php echo $selectedCarrier === $carrier->servicecode ? 'checked' : '' ?>
                        />
                        <label for="polkurier_default_id_<?php echo $carrier->servicecode ?>">
                            <?php echo $carrier->name ?>
                        </label>
                        <div id="courier-<?php echo $carrier->servicecode ?>-messages-container" class="courier-messages-container" style="display: none;">
                            <?php
                                foreach ($couriersMessagesManager->getByCourier($carrier->servicecode) as $message) {
                                    ?>
                                        <div class="notice e-notice e-notice--<?php echo strtolower($message->severity) ?>" >
                                            <div class="e-notice__content">
                                                <?php echo $message->message ?>
                                            </div>
                                        </div>
                                    <?PHP
                                }
                            ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </td>
        </tr>
        <tr>
            <td></td>
            <td>
                <div id="polkurier-evaluation-spinner"></div>
                <div id="polkurier-evaluation-error"></div>
            </td>
        </tr>
        <tr id="pickuptime" class="">
            <th scope="row">
                <label for="polkurier_package">
                    Odbiór paczki od nadawcy
                </label>
            </th>
            <td>
                <table class="form-table">
                    <tbody>
                    <tr>
                        <th scope="row">
                            <label for="polkurier_pickup_type">Sposób odbioru</label>
                        </th>
                        <td>
                            <select name="polkurier_pickup_type" id="polkurier_pickup_type">
                                <option value="COURIER_PICKUP" <?php echo isset($_POST['polkurier_pickup_type']) && $_POST['polkurier_pickup_type'] === 'COURIER_PICKUP' ? 'selected' : NULL ?>>Zamawiam odbiór przesyłek </option>
                                <option value="SELF_PICKUP" <?php echo isset($_POST['polkurier_pickup_type']) && $_POST['polkurier_pickup_type'] === 'SELF_PICKUP' ? 'selected' : NULL ?>>Samodzielnie dostarczę przesyłkę do punktu</option>
                            </select>
                        </td>
                        <script>
                            var LABELS = {
                                INPOST: 'Samodzielnie dostarczę przesyłkę do punktu',
                                INPOST_PACZKOMAT: 'Samodzielnie dostarczę przesyłkę do paczkomatu',
                                INPOST_PACZKOMAT_ALLEGRO: 'Samodzielnie dostarczę przesyłkę do paczkomatu',
                                INPOST_PACZKOMAT_ECONOMY: 'Samodzielnie dostarczę przesyłkę do paczkomatu',
                                INPOST_PACZKOMAT_KURIER: 'Samodzielnie dostarczę przesyłkę do paczkomatu',
                                INPOST_INTERNATIONAL: 'Samodzielnie dostarczę przesyłkę do paczkomatu',
                                POCZTEX_PUNKT: 'Samodzielnie dostarczę przesyłkę do placówki Poczty Polskiej',
                                POCZTEX_PUNKT_PUNKT: 'Samodzielnie dostarczę przesyłkę do placówki Poczty Polskiej',
                                PACZKA_W_RUCHU: 'Samodzielnie dostarczę przesyłkę punktu',
                                DPD_POINT: 'Samodzielnie dostarczę przesyłkę do punktu.',
                                DHL_POINT: 'Samodzielnie dostarczę przesyłkę do punktu POP',
                                UPS_AP_POINT_POINT: 'Samodzielnie dostarczę przesyłkę do punktu UPS',
                                UPS_AP_POINT_COURIER: 'Samodzielnie dostarczę przesyłkę do punktu UPS',
                                DEFAULT: 'Zamówię kuriera samodzielnie przez telefon'
                            };

                            var SELF_PICKUP = [
                                'INPOST_PACZKOMAT',
                                'INPOST_PACZKOMAT_ALLEGRO',
                                'INPOST_PACZKOMAT_ECONOMY',
                                'INPOST_PACZKOMAT_KURIER',
                                'INPOST_INTERNATIONAL',
                                'POCZTEX_PUNKT',
                                'POCZTEX_PUNKT_PUNKT',
                                'PACZKA_W_RUCHU',
                                'DPD_POINT',
                                'UPS_AP_POINT_POINT',
                                'UPS_AP_POINT_COURIER',
                            ];

                            var changePickupType = function (type) {
                                jQuery('option[value="' + type + '"]').prop('selected', true);
                                jQuery('[name="polkurier_pickup_type"]').trigger('change');
                            };

                            var updatePickupOptions = function () {
                                var currentCourier = getCurrentCarrier() || {};
                                var additionalData = currentCourier.additional_data || {};
                                var pickup = additionalData.pickup || {};
                                var option = jQuery('option[value="SELF_PICKUP"]');
                                option.text(LABELS[currentCourier.servicecode] || LABELS.DEFAULT);

                                if (pickup.nocourierorder && pickup.nocourierorder.available === true) {
                                    option.prop('disabled', false).show();
                                } else {
                                    changePickupType('COURIER_PICKUP');
                                    option.prop('disabled', true).hide();
                                }

                                var disallowCourierPickup = pickup.pickupdate && pickup.pickupdate.status === false
                                jQuery('option[value="COURIER_PICKUP"]').prop('disabled', disallowCourierPickup).toggle(!disallowCourierPickup);
                            };

                            var updatePickupSelect = function () {
                                var pickupType = jQuery('[name="polkurier_pickup_type"]').val();
                                if (pickupType === 'SELF_PICKUP') {
                                    jQuery('#polkurier_date').prop('disabled' , true);
                                    jQuery('#polkurier_pickup_date_select').prop('disabled' , true);
                                } else {
                                    jQuery('#polkurier_date').prop('disabled', false);
                                    jQuery('#polkurier_pickup_date_select').prop('disabled', false);
                                }
                            };

                            var onChangeCourierSelect = function () {
                                var currentCourier = getCurrentCarrier() || {};
                                if (currentCourier && SELF_PICKUP.indexOf(currentCourier.servicecode) !== -1) {
                                    changePickupType('SELF_PICKUP');
                                } else {
                                    changePickupType('COURIER_PICKUP');
                                }
                                updatePickupOptions();
                            };

                            jQuery(document)
                                .on('change', '[name="polkurier_carrier_id"]', onChangeCourierSelect)
                                .on('change', '[name="polkurier_pickup_type"]', updatePickupSelect)
                                .ready(function () {
                                    updatePickupOptions();
                                    updatePickupSelect();
                                });

                            updatePickupOptions();
                            updatePickupSelect();
                            onChangeCourierSelect();
                        </script>
                    </tr>
                    <tr>
                        <th scope="row"><label for="polkurier_date">Data</label></th>
                        <td><input required type="date" class="polkurier_dates" name="polkurier_date"
                                   id="polkurier_date"
                                   value="<?php echo isset($_POST['polkurier_date']) ? $_POST['polkurier_date'] : NULL ?>">
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="polkurier_pickup_date_select">
                                Godzina
                            </label>
                        </th>
                        <td>
                            <span id="polkurier_pickup_date"></span>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </td>
        </tr>
        <tr id="polkurier-sender-point-container">
            <th scope="row">
                <label id="polkurier-sender-point-label">Paczkomat nadawcy</label>
            </th>
            <td>
                <div>
                    <select name="sender_machinename" id="polkurier-sender-point" data-type="sender">
                        <option value="">---</option>
                        <?php if (!empty($_POST['sender_machinename'])): ?>
                            <option value="<?php echo $_POST['sender_machinename']  ?>" data-default="1" data-provider="<?php echo $selectedCarrier ?>" selected>
                                <?php echo $_POST['sender_point_name'] ?>
                            </option>
                        <?php endif; ?>
                    </select>
                    <button type="button" class="button button-primary" id="polkurier-sender-point-map-button">Mapa</button>
                    <button type="button" class="button button-primary" id="polkurier-sender-default-button">Ustaw domślny</button>
                </div>
            </td>
        </tr>
        <tr id="polkurier-recipient-point-container">
            <th scope="row">
                <label id="polkurier-recipient-point-label">Paczkomat odbiorcy</label>
            </th>
            <td>
                <div>
                    <select name="recipient_machinename" id="polkurier-recipient-point" data-type="recipient">
                        <option value="">---</option>
                        <?php if (!empty($orderSelectedPointId)): ?>
                        <option value="<?php echo $orderSelectedPointId ?>" data-default="1" data-provider="<?php echo $selectedCarrier ?>" selected>
                            <?php if (!empty($_POST['recipient_point_name'])): ?>
                                <?php echo $_POST['recipient_point_name'] ?>
                            <?php else: ?>
                                [<?php echo $orderSelectedPointId ?>]
                                <?php echo !empty($orderSelectedPointLabel) ? $orderSelectedPointLabel : '' ?>
                            <?php endif ?>
                        </option>
                        <?php endif ?>
                    </select>
                    <button type="button" class="button button-primary" id="polkurier-recipient-point-map-button">Mapa</button>
                </div>
            </td>
        </tr>

        <input type="hidden" name="sender_point_name" id="sender_point_name" />
        <input type="hidden" name="recipient_point_name" id="recipient_point_name" />
        <script>
            var senderSelect = jQuery('select.sender-point');
            jQuery('#polkurier-sender-point').on('change', function () {
                jQuery('#sender_point_name').val(jQuery(this).find('option:selected').text());
            });
            jQuery('#polkurier-recipient-point').on('change', function () {
                jQuery('#recipient_point_name').val(jQuery(this).find('option:selected').text());
            });
        </script>

        <tr class="polkurier_standard_address">
            <th scope="row">
                <label for="polkurier_address">
                    Adres nadawcy
                </label>
            </th>
            <td>
                <?php
                    $addresses = $addressBook->getSenderAddresses();
                    $selectedAddressId = $request->request->getString('polkurier_address');
                ?>
                <select name="polkurier_address" id="polkurier_address">
                    <?php foreach ($addresses as $address): ?>
                        <option
                            <?php echo ($selectedAddressId && $address->id === $selectedAddressId) || (!$selectedAddressId && $address->default) ? 'selected' : ''  ?>
                            id="polkurier_address_<?php echo $address->id ?>"
                            value="<?php echo $address->id ?>"
                            class="polkurier_address_option"
                            data-postalcode="<?php echo $address->postcode ?>"
                        >
                            <?php echo $address->company . " - " . $address->person ?>
                        </option>
                    <?php endforeach; ?>
                </select>
                <br/>
                <?php foreach ($addresses as $address): ?>
                    <input
                        type="radio"
                        name="polkurier_address_radio"
                        id="polkurier_address_radio_<?php echo $address->id ?>"
                        value="<?php echo $address->id ?>"
                        <?php if (!isset($_POST['polkurier_adress_radio']) && $address->id === 0) {
                            echo "checked";
                        } else if (isset($_POST['polkurier_address_radio']) && $_POST['polkurier_address_radio'] === $address->id) {
                            echo "checked";
                        } else if (!isset($_POST['polkurier_address_radio']) && $address->default) {
                            echo "checked";
                        }
                        ?>
                    >
                    <label for="polkurier_address_radio_<?php echo $address->id ?>">
                        <?php
                            echo implode('<br>', array_filter([
                                $address->company,
                                $address->person,
                                $address->street . " " . $address->housenumber . " " . $address->flatnumber,
                                $address->postcode . " " . $address->city,
                                $address->phone,
                                $address->email
                            ]));
                        ?>
                    </label>
                <?php
                    endforeach;


                if (empty($addresses)) {
                    echo '<div class="notice error polkurier-notice is-dismissible" ><p>Proszę uzupełnić domyślny adres nadawcy</p></div>';
                }
                ?>
            </td>
        </tr>

        <tr class="polkurier_standard_address">
            <th scope="row">
                <label for="polkurier_receiver">Adres odbiorcy</label>
            </th>
            <td>
                <?php
                    $polkurier_get_recipient_address_row = static function ($field) use ($order_data) {
                        if (!empty($_POST['recipient'][$field])) {
                            return $_POST['recipient'][$field];
                        }
                        switch ($field) {
                            case 'person':
                                return $order_data['shipping']['first_name'] . " " . $order_data['shipping']['last_name'];
                            case 'street':
                                return trim($order_data['shipping']['address_1'] . ' ' . $order_data['shipping']['address_2']);
                            case 'email':
                            case 'phone':
                                return $order_data['billing'][$field];
                            default:
                                return $order_data['shipping'][$field];
                        }
                    }
                ?>
                <div class="pk-mb-2" style="width: 400px;">
                    Firma
                    <div>
                        <input type="text" name="recipient[company]" value="<?php echo $polkurier_get_recipient_address_row('company') ?>">
                    </div>
                </div>
                <div class="pk-mb-2">
                    Imię i nazwisko
                    <div>
                        <input type="text" name="recipient[person]" value="<?php echo $polkurier_get_recipient_address_row('person') ?>">
                    </div>
                </div>
                <div class="pk-mb-2">
                    Ulica i numer
                    <div>
                        <input type="text" name="recipient[street]" value="<?php echo $polkurier_get_recipient_address_row('street') ?>">
                    </div>
                </div>
                <div class="pk-mb-2">
                    Miejscowość
                    <div>
                        <input type="text" name="recipient[city]" value="<?php echo $polkurier_get_recipient_address_row('city') ?>">
                    </div>
                </div>
                <div class="pk-mb-2">
                    Kod pocztowy
                    <div>
                        <input type="text" name="recipient[postcode]" value="<?php echo $polkurier_get_recipient_address_row('postcode') ?>">
                    </div>
                </div>
                <div class="pk-mb-2">
                    Kraj (kod ISO)
                    <div>
                        <input type="text" name="recipient[country]" value="<?php echo $polkurier_get_recipient_address_row('country') ?>">
                    </div>
                </div>
                <div class="pk-mb-2">
                    Telefon
                    <div>
                        <input type="text" name="recipient[phone]" value="<?php echo $polkurier_get_recipient_address_row('phone') ?>">
                    </div>
                </div>
                <div class="pk-mb-2">
                    Adres email
                    <div>
                        <input type="text" name="recipient[email]" value="<?php echo $polkurier_get_recipient_address_row('email') ?>">
                    </div>
                </div>
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="polkurier_pobranie">Kwota pobrania</label>
            </th>
            <td>
                <input type="text" name="polkurier_pobranie" id="polkurier_pobranie" value="<?php echo $codAmount ?>">
            </td>
        </tr>
        <tr>
            <th scope="row"><label for="polkurier_pobranie_rodzaj">Rodzaj zwrotu pobrania</label></th>
            <td>
                <?php
                    $cod_return_type = isset($_POST['polkurier_pobranie_rodzaj']) ? (string)$_POST['polkurier_pobranie_rodzaj'] : '';
                    $default_cod_return_type = get_option('polkurier_DEFAULT_COD_RETURN_TYPE', 'BA');
                    if (empty($cod_return_type) && !empty($default_cod_return_type)) {
                        $cod_return_type = $default_cod_return_type;
                    }
                ?>
                <div class="pk-my-4">
                    <input type="radio" <?php if ($cod_return_type === 'BA') echo 'checked' ?> name="polkurier_pobranie_rodzaj" id="polkurier_pobranie_rodzaj_1" value="BA">
                    <label for="polkurier_pobranie_rodzaj_1">Przelew na konto bankowe</label><br/>
                </div>
                <div class="pk-my-4">
                    <input type="radio" <?php if ($cod_return_type === 'PO') echo 'checked' ?> name="polkurier_pobranie_rodzaj" id="polkurier_pobranie_rodzaj_2" value="PO">
                    <label for="polkurier_pobranie_rodzaj_2">Przekaz pocztowy na adres nadawcy</label>
                    <div class="pk-ml-5">
                        <small>Usługa Poczty Polskiej – kwotę pobrania zwraca listonosz na dane Nadawcy (podstawowy termin + 2 dni robocze)</small>
                    </div>
                </div>
                <div class="pk-my-4">
                    <input type="radio" <?php if ($cod_return_type === 'MB') echo 'checked' ?> name="polkurier_pobranie_rodzaj" id="polkurier_pobranie_rodzaj_3" value="MB">
                    <label for="polkurier_pobranie_rodzaj_3">
                        Do skarbonki
                    </label>
                    <div class="pk-ml-5">
                        <small>
                            Skarbonka umożliwia Ci zbieranie pobrań na swoim koncie tak, by wypłacać je w terminie, który Tobie odpowiada.<br>
                            Więcej informacji znajdziesz w naszej
                            <a href="https://polkurier.pl/knowledge-base/article/skarbonka" target="_blank">
                                bazie wiedzy
                            </a>
                        </small>
                    </div>
                </div>
            </td>
        </tr>
        <tr>
            <th scope="row"><label for="polkurier_pobranie_zwrot">Zwrot pobrania</label></th>
            <td>
                <?PHP
                    $codType = $request->request->getString('polkurier_pobranie_zwrot');
                    if (empty($codType)) {
                        $codType = get_option('polkurier_DEFAULT_COD_TYPE');
                    }
                    if (empty($codType)) {
                        $codType = 'S';
                    }
                ?>
                <input
                    type="radio"
                    id="polkurier_pobranie_zwrot_1"
                    name="polkurier_pobranie_zwrot"
                    value="S"
                    <?php echo $codType === 'S' ? 'checked' : '' ?>
                >
                <label for="polkurier_pobranie_zwrot_1">od 5 do 7 dni roboczych</label><br/>
                <input
                    type="radio"
                    id="polkurier_pobranie_zwrot_2"
                    name="polkurier_pobranie_zwrot"
                    value="1D"
                    <?php echo $codType === '1D' ? 'checked' : '' ?>
                >
                <label for="polkurier_pobranie_zwrot_2">1 dzień roboczy od daty dostarczenia przesyłki</label><br/>
                <input
                    type="radio"
                    id="polkurier_pobranie_zwrot_3"
                    name="polkurier_pobranie_zwrot"
                    value="4D"
                    <?php echo $codType === '4D' ? 'checked' : '' ?>
                >
                <label for="polkurier_pobranie_zwrot_3">4 dni robocze od daty dostarczenia przesyłki</label><br/>
                <input
                    type="radio"
                    id="polkurier_pobranie_zwrot_4"
                    name="polkurier_pobranie_zwrot"
                    value="16D"
                    <?php echo $codType === '16D' ? 'checked' : '' ?>
                >
                <label for="polkurier_pobranie_zwrot_4">16 dni robocze od daty dostarczenia przesyłki</label><br/>
            </td>
        </tr>
        <tr>
            <th scope="row"><label for="polkurier_pobranie">Konto bankowe do zwrotu pobrania</label></th>
            <td>
                <?php
                    $codAccount = $request->request->getString('polkurier_account');
                ?>
                <select id="polkurier_account" name="polkurier_account">
                    <?php foreach ((new BankAccountsManager())->getAll() as $account): ?>
                        <option
                            value="<?php echo $account->account ?>"
                            <?php echo (($codAccount && $account->account === $codAccount) || (!$codAccount && $account->default)) ? 'selected' :'' ?>
                        >
                            <?php echo $account->alias . " — " . $account->account ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </td>
        </tr>
        <tr>
            <th scope="row"><label for="polkurier_ubezpieczenie">Kwota ubezpieczenia</label></th>
            <td><input type="text" name="polkurier_ubezpieczenie" id="polkurier_ubezpieczenie"
                       value="<?php echo $insurance ?>">
            </td>
        </tr>
        <tr>
            <th scope="row"><label for="polkurier_description">Opis zawartości</label></th>
            <td><textarea required name="polkurier_description"
                          id="polkurier_description"><?php echo isset($_POST['polkurier_description']) && !empty($_POST['polkurier_description']) ? $_POST['polkurier_description'] : ('Zamówienie #' . $order_data['id']) ?></textarea>
            </td>
        </tr>

        <tr>
            <th scope="row">
                <label>Usługi dodatkowe</label>
            </th>
            <td>
                <div class="pk-my-4">
                    <label>
                        <input type="checkbox" name="courierservice[ROD]" <?php echo pk_get_post_param('courierservice.ROD') === '1' ? 'checked' : '' ?> value="1" />
                        <strong>Dokumenty zwrotne</strong>
                    </label>
                </div>
                <div class="pk-my-4">
                    <label>
                        <input type="checkbox" name="courierservice[COURIER_WITH_LABEL]" <?php echo pk_get_post_param('courierservice.COURIER_WITH_LABEL') === '1' ? 'checked' : '' ?> value="1" />
                        <strong>Podjazd kuriera z wydrukowanym listem przewozowym</strong>
                    </label>
                    <div class="pk-ml-5">
                        <small>Usługa dostępna tylko dla przewoźnika DHL</small>
                    </div>
                </div>
                <div class="pk-my-4">
                    <label>
                        <input type="checkbox" name="courierservice[WEEK_COLLECTION]" <?php echo pk_get_post_param('courierservice.WEEK_COLLECTION') === '1' ? 'checked' : '' ?> value="1" />
                        <strong>Dostawa weekendowa</strong>
                    </label>
                    <div class="pk-ml-5">
                        <small>Usługa dostępna tylko dla przewoźnika InPost Paczkomaty 24/7</small>
                    </div>
                </div>
                <div class="pk-my-4">
                    <label>
                        <?php
                            $enabled = $isPost
                                ? pk_get_post_param('courierservice.SMS_NOTIFICATION_RECIPIENT') === '1'
                                : get_option('polkurier_default_courierservice_SMS_NOTIFICATION_RECIPIENT') === '1';
                        ?>
                        <input type="checkbox" name="courierservice[SMS_NOTIFICATION_RECIPIENT]" <?php echo $enabled ? 'checked' : '' ?> value="1" />
                        <strong>Powiadomienie SMS dla odbiorcy</strong>
                    </label>
                    <div class="pk-ml-5">
                        <small>Powiadomienie zostanie wysłane po odebraniu przesyłki od nadawcy</small>
                    </div>
                </div>
                <div class="pk-my-4">
                    <label>
                        <?php
                            $enabled = $isPost
                                ? pk_get_post_param('courierservice.SMS_NOTIFICATION_RECIPIENT_WITH_NAME') === '1'
                                : get_option('polkurier_default_courierservice_SMS_NOTIFICATION_RECIPIENT_WITH_NAME') === '1';
                        ?>
                        <input type="checkbox" name="courierservice[SMS_NOTIFICATION_RECIPIENT_WITH_NAME]" <?php echo $enabled ? 'checked' : '' ?> value="1" />
                        <strong>Powiadomienie SMS dla odbiorcy z własną nazwą nadawcy</strong>
                    </label>
                    <div class="pk-ml-5">
                        <small>
                            Powiadomienie zostanie wysłane po odebraniu przesyłki od nadawcy<br>
                            Jako nadawca wiadomości będzie widnieć Twoja nazwa.<br>
                            Wymagane jest ustawienie domyślnej nazwy nadawcy w panelu klienta na portalu
                            <a href="https://polkurier.pl">Polkurier.pl</a> w zakładce "Ustawienia" &rarr; "Powiadomienia"
                        </small>
                    </div>
                </div>
                <script>
                    (function () {
                        var $smsNotificationRecipient = jQuery('[name="courierservice[SMS_NOTIFICATION_RECIPIENT]"]');
                        var $smsNotificationRecipientWithName = jQuery('[name="courierservice[SMS_NOTIFICATION_RECIPIENT_WITH_NAME]"]');
                        $smsNotificationRecipient.on('change', function () {
                            $smsNotificationRecipientWithName.prop('checked', false);
                        });
                        $smsNotificationRecipientWithName.on('change', function () {
                            $smsNotificationRecipient.prop('checked', false);
                        });

                        var $weekCollection = jQuery('[name="courierservice[WEEK_COLLECTION]"]');
                        var $courierWithLabel = jQuery('[name="courierservice[COURIER_WITH_LABEL]"]');

                        var updateView = function () {
                            var $courier = jQuery('[name="polkurier_carrier_id"]:checked');
                            var courier = $courier.val();
                            $courierWithLabel
                                .prop('disabled', courier !== 'DHL')
                                .prop('checked', courier === 'DHL' && $weekCollection.is(':checked'));
                            $weekCollection
                                .prop('disabled', courier !== 'INPOST_PACZKOMAT')
                                .prop('checked', courier === 'INPOST_PACZKOMAT' && $weekCollection.is(':checked'));
                        };

                        jQuery('[name="polkurier_carrier_id"]').on('change', updateView);
                        updateView();
                    }) ();
                </script>

                <div class="pk-my-4">
                    <label>
                        <?php
                            $polkurier_cover_addresses = $addressBook->getCoverAddresses();
                            $polkurier_cover_address_id = Arr::get($_POST, 'polkurier_cover_address');
                            $cover_address_sender_enabled = $polkurier_cover_address_id !== null || (int)get_option('polkurier_default_courierservice_COVER_ADDRESS_SENDER') === 1;

                            if ($polkurier_cover_address_id === null && $cover_address_sender_enabled) {
                                foreach ($polkurier_cover_addresses as $address) {
                                    if ($address->default) {
                                        $polkurier_cover_address_id = $address->id;
                                        break;
                                    }
                                }
                            }
                        ?>
                        <input type="checkbox" <?php echo $cover_address_sender_enabled ? 'checked' : '' ?> id="polkurier_cover_address_toggle" autocomplete="off" />
                        <strong>Inny adres nadawcy na etykiecie</strong>
                        <select name="polkurier_cover_address" id="polkurier_cover_address" onchange="evaluateOrder()" autocomplete="off">
                            <option selected value="null">---</option>
                            <?php foreach ($polkurier_cover_addresses as $address): ?>
                                <option
                                    id="polkurier_cover_address_<?php echo $address->id ?>"
                                    value="<?php echo $address->id ?>"
                                    class="polkurier_address_option"
                                    data-postalcode="<?php echo $address->postcode ?>"
                                    <?php echo ($polkurier_cover_address_id !== null && (int)$polkurier_cover_address_id === $address->id) ? "selected" : '' ?>
                                >
                                    <?php echo $address->company . " - " . $address->person ?>
                                </option>
                            <?php endforeach ?>
                        </select>
                    </label>
                    <div class="pk-ml-5">
                        <small>
                            Usługa umożliwia zakrycie Twojego rzeczywistego adresu nadawczego na liście przewozowym.<br>
                            Listą adresów można zarządzać w zakładce
                            <a href="?page=polkurier&tab=cover_addresses">
                                "WooCommerce" &rarr; "Ustawienia Polkurier" &rarr; "Adresy na etykiecie"
                            </a>
                        </small>
                    </div>
                </div>
                <script>
                    (function () {
                        const $toggle = jQuery('#polkurier_cover_address_toggle');
                        const $select = jQuery('#polkurier_cover_address');
                        const updateView = function () {
                            const isChecked = $toggle.is(':checked');
                            $select.toggle(isChecked);
                            $select.prop('disabled', !isChecked);
                        };
                        $toggle.on('change', updateView);
                        updateView();
                    }) ();
                </script>

            </td>
        </tr>

        <tr>
        </tbody>
    </table>
    <?php submit_button("Wyślij", "primary", "submit", true, ['onclick' => 'return fn_polkurier_validate_package()']); ?>
</form>

<?php
    require __DIR__ . '/scripts-js.php';
    require __DIR__ . '/styles-css.php';
?>
